"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
const defaults = require("@aws-solutions-constructs/core");
const app = new core_1.App();
// Empty arguments
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
const construct = new lib_1.KinesisFirehoseToAnalyticsAndS3(stack, 'test-kinesisfirehose-analytics-s3', {
    kinesisAnalyticsProps: {
        inputs: [{
                inputSchema: {
                    recordColumns: [{
                            name: 'ticker_symbol',
                            sqlType: 'VARCHAR(4)',
                            mapping: '$.ticker_symbol'
                        }, {
                            name: 'sector',
                            sqlType: 'VARCHAR(16)',
                            mapping: '$.sector'
                        }, {
                            name: 'change',
                            sqlType: 'REAL',
                            mapping: '$.change'
                        }, {
                            name: 'price',
                            sqlType: 'REAL',
                            mapping: '$.price'
                        }],
                    recordFormat: {
                        recordFormatType: 'JSON'
                    },
                    recordEncoding: 'UTF-8'
                },
                namePrefix: 'SOURCE_SQL_STREAM'
            }]
    },
    bucketProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY,
    },
    logS3AccessLogs: false
});
const s3Bucket = construct.s3Bucket;
defaults.addCfnSuppressRules(s3Bucket, [
    { id: 'W35',
        reason: 'This S3 bucket is created for unit/ integration testing purposes only.' },
]);
app.synth();
//# sourceMappingURL=data:application/json;base64,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