from exploits.tree import huffman
from test.exploits.dummy_output import DummyOutput
from input.chars import CharGenerator


def test_run():
    output = DummyOutput()
    expected = 'abccdddeeeee'
    n_inputs = len(expected)
    huffman.options['n_inputs'] = n_inputs
    huffman.run(CharGenerator(), output)
    assert len(output) == 1
    assert output[0] == expected


def test_run_larger_output():
    output = DummyOutput()
    expected = 'abccdddeeeeeffffffffggggggggggggg'
    n_inputs = len(expected)
    huffman.options['n_inputs'] = n_inputs
    huffman.run(CharGenerator(), output)
    assert len(output) == 1
    assert output[0] == expected
