import pytest
from exploits.linear_programming import simplex
from test.exploits.dummy_output import DummyOutput


def test_run():
    output = DummyOutput()
    order = 2
    simplex.options['order'] = order
    simplex.options['mu'] = 3.0
    simplex.options['pivot_type'] = 'largest_coefficient'
    simplex.run(output)
    assert len(output) == 3
    assert len(output[0]) == order
    assert len(output[1]) == order
    for i in range(order):
        assert len(output[1][i]) == order
    assert len(output[2]) == order


def test_smallest_index_pivot():
    output = DummyOutput()
    order = 2
    simplex.options['order'] = order
    simplex.options['mu'] = 3.0
    simplex.options['pivot_type'] = 'smallest_index'
    simplex.run(output)
    assert len(output) == 3
    assert len(output[0]) == order
    assert len(output[1]) == order
    for i in range(order):
        assert len(output[1][i]) == order
    assert len(output[2]) == order


def test_larger_order():
    output = DummyOutput()
    order = 200
    simplex.options['order'] = order
    simplex.options['mu'] = 3.0
    simplex.options['pivot_type'] = 'largest_coefficient'
    simplex.run(output)
    assert len(output) == 3
    assert len(output[0]) == order
    assert len(output[1]) == order
    for i in range(order):
        assert len(output[1][i]) == order
    assert len(output[2]) == order


def test_mu_too_small():
    output = DummyOutput()
    order = 200
    simplex.options['order'] = order
    simplex.options['mu'] = 2.0
    simplex.options['pivot_type'] = 'largest_coefficient'
    with pytest.raises(ValueError):
        simplex.run(output)
