from exploits.hashes.collisions import php5_fast
from exploits.hashes.collisions import php5_common
from test.exploits.dummy_output import DummyOutput
from input.chars import CharGenerator


def test_run_small_collision_count():
    output = DummyOutput()
    n_collisions = 20
    hash_table_size = 2**32
    target = '42'
    php5_fast.options['n_collisions'] = n_collisions
    php5_fast.options['n_substrings'] = 10
    php5_fast.options['target_type'] = 'image'
    php5_fast.options['target'] = target
    php5_fast.options['hash_table_size'] = hash_table_size
    php5_fast.run(CharGenerator(), output)
    assert output.count() == n_collisions
    for i in output:
        assert php5_common.php_hash(i, hash_table_size) == int(target)


def test_run_large_collision_count():
    output = DummyOutput()
    n_collisions = 10000
    hash_table_size = 2**32
    target = '42'
    php5_fast.options['n_collisions'] = n_collisions
    php5_fast.options['n_substrings'] = 10
    php5_fast.options['target_type'] = 'image'
    php5_fast.options['target'] = target
    php5_fast.options['hash_table_size'] = hash_table_size
    php5_fast.run(CharGenerator(), output)
    assert output.count() == n_collisions
    for i in output:
        assert php5_common.php_hash(i, hash_table_size) == int(target)


def test_preimage():
    output = DummyOutput()
    n_collisions = 10
    hash_table_size = 2**32
    preimage_target = 'hello world'
    php5_fast.options['n_collisions'] = n_collisions
    php5_fast.options['n_substrings'] = 10
    php5_fast.options['target_type'] = 'preimage'
    php5_fast.options['target'] = preimage_target
    php5_fast.options['hash_table_size'] = hash_table_size
    php5_fast.run(CharGenerator(), output)
    target = php5_common.php_hash(preimage_target, hash_table_size)
    assert output.count() == n_collisions
    for i in output:
        assert php5_common.php_hash(i, hash_table_size) == target


def test_run_small_hash_table_size():
    output = DummyOutput()
    n_collisions = 10
    hash_table_size = 1024
    target = '42'
    php5_fast.options['n_collisions'] = n_collisions
    php5_fast.options['target_type'] = 'image'
    php5_fast.options['n_substrings'] = 3
    php5_fast.options['target'] = target
    php5_fast.options['hash_table_size'] = hash_table_size
    php5_fast.run(CharGenerator(), output)
    assert output.count() == n_collisions
    for i in output:
        assert php5_common.php_hash(i, hash_table_size) == int(target)
