from exploits.hashes.collisions import java_z3
from exploits.hashes.collisions import java_common
from test.exploits.dummy_output import DummyOutput


# java_z3 takes a while so just one test where we generate one item
def test_run():
    output = DummyOutput()
    n_collisions = 1
    hash_table_size = 2**32
    target = '42'
    length = 10
    java_z3.options['n_collisions'] = n_collisions
    java_z3.options['length'] = length
    java_z3.options['target_type'] = 'image'
    java_z3.options['target'] = target
    java_z3.options['hash_table_size'] = hash_table_size
    java_z3.run(output)
    assert output.count() == n_collisions
    for i in output:
        assert java_common.java_hash(i, hash_table_size) == int(target)
        assert len(i) == length
