import copy

class DummyOutput:
    """TestOutput class.  Used as an output during tests.  It provides a single
       function that just stores a copy of the output passed to it for later
       inspection"""

    def __init__(self):
        self.output_called = False
        self.output_list = []

    def __getitem__(self, key):
        return self.output_list[key]

    def __len__(self):
        return self.count()

    def __iter__(self):
        self.iter_index = 0
        return self

    def __next__(self):
        if self.iter_index < len(self.output_list):
            self.iter_index += 1
            return self.output_list[self.iter_index - 1]
        else:
            raise StopIteration

    def output(self, output_list):
        self.output_list = copy.copy(output_list)

    def count(self):
        return len(self.output_list)
