import pytest
from exploits.bombs.images import jpeg_bad_header
from test.exploits.dummy_output import DummyOutput


def test_jpeg_bad_header():
    output = DummyOutput()
    jpeg_bad_header.options['height'] = 100
    jpeg_bad_header.options['width'] = 100
    jpeg_bad_header.run(output)
    assert len(output) == 1


def test_negative_width_header():
    output = DummyOutput()
    jpeg_bad_header.options['height'] = 100
    jpeg_bad_header.options['width'] = -100
    with pytest.raises(ValueError):
        jpeg_bad_header.run(output)


def test_negative_height_header():
    output = DummyOutput()
    jpeg_bad_header.options['height'] = -100
    jpeg_bad_header.options['width'] = 100
    with pytest.raises(ValueError):
        jpeg_bad_header.run(output)


def test_width_too_large_header():
    output = DummyOutput()
    jpeg_bad_header.options['height'] = 100
    jpeg_bad_header.options['width'] = 2**30
    with pytest.raises(ValueError):
        jpeg_bad_header.run(output)


def test_height_too_large_header():
    output = DummyOutput()
    jpeg_bad_header.options['height'] = 2**30
    jpeg_bad_header.options['width'] = 100
    with pytest.raises(ValueError):
        jpeg_bad_header.run(output)
