import gzip
from exploits.bombs.compression import gz
from test.exploits.dummy_output import DummyOutput


def test_recursive_bomb():
    output = DummyOutput()
    gz.options['type'] = 'recursive'
    gz.run(output)
    assert output.count() == 1


def test_single_file_bomb():
    output = DummyOutput()
    target_size = 1000
    gz.options['type'] = 'single_file'
    gz.options['target_size'] = target_size
    gz.run(output)
    assert output.count() == 1
    assert len(gzip.decompress(output[0])) == target_size


def test_single_file_different_sizes():
    output1 = DummyOutput()
    output2 = DummyOutput()
    target_size1 = 10000
    target_size2 = 100000
    gz.options['type'] = 'single_file'
    gz.options['target_size'] = target_size1
    gz.run(output1)
    gz.options['target_size'] = target_size2
    gz.run(output2)
    assert output1.count() == 1
    assert output2.count() == 1
    assert len(output1[0]) < len(output2[0])
