import math
from acsploit.options import Options


# TODO - add option to optimize for filesize or huffman tree depth
options = Options()
options.add_option('n_inputs', 10, 'Number of characters in string to be Huffman encoded')
# Creates the maximal depth Huffman tree from an input of n_inputs characters.

DESCRIPTION = 'Produces a worst-case string for creation of a Huffman tree' \
              '\n\n  ' \
              'Character frequencies following the Fibonacci sequence cause a max-depth Huffman tree.'


DEFAULT_INPUT = 'char'


def run(generator, output):
    output.output([exploit(generator, options['n_inputs'])])


def exploit(generator, n_inputs):
    characters = ''
    n = generator.get_min_value()
    count = 1
    while (len(characters) + fib(count)) <= n_inputs:
        characters += n * fib(count)
        n = generator.get_greater_than(n)
        count += 1
    return characters


def fib(n):
    # Generates the nth Fibonacci number
    return int(((1 + math.sqrt(5)) ** n - (1 - math.sqrt(5)) ** n) / (2 ** n * math.sqrt(5)))
