import logging
from acsploit.options import Options


options = Options()
options.add_option('n_inputs', 10, 'Number of elements in heap')
options.add_option('type', 'max', 'Type of heap', ['min', 'max'])

DESCRIPTION = 'Produces a worst-case set of inputs for insertion in a heap' \
              '\n\n  ' \
              'The worst case for min-heap is a descending list, as each insertion changes the min element. ' \
              'The worst case for max-heap is an ascending list, as each insertion changes the max element.'


def run(generator, output):
    if options['type'] == 'max':
        output.output(ascending_list(generator, options['n_inputs']))
    elif options['type'] == 'min':
        output.output(descending_list(generator, options['n_inputs']))
    else:
        raise ValueError('Not a valid type')


def descending_list(generator, numnodes):
    output = [generator.get_max_value()]
    for i in range(1,numnodes):
        output.append(generator.get_less_than(output[i-1]))
    return output


def ascending_list(generator, numnodes):
    output = [generator.get_min_value()]
    for i in range(1,numnodes):
        output.append(generator.get_greater_than(output[i-1]))
    return output
