from acsploit.options import Options


options = Options()
options.add_option('n_inputs', 10, 'Number of nodes in tree (to insert)')
# Worst case for node insertion in a B tree.

DESCRIPTION = 'Produces a worst-case set of inputs for insertion in a B-Tree' \
              '\n\n  ' \
              'Sorted insertions maximize balancing operations, resulting in the worst case input.'


def run(generator, output):
    ret = sorted_list(generator, options['n_inputs'])
    output.output(ret)


def sorted_list(generator, n_inputs):
    output = [generator.get_max_value()]
    for i in range(1, n_inputs):
        output.append(generator.get_less_than(output[i - 1]))
    return output
