from acsploit.options import Options


options = Options()
options.add_option('string_length', 120, 'Length of string to generate')

DESCRIPTION = 'Produces a worst-case string for line-breaking algorithms' \
              '\n\n  ' \
              'Fits as many words as possible into the string_length constraint, maximizing the number of possible ' \
              'line breaks considered.'

DEFAULT_INPUT = 'char'


def run(generator, output):
    target_length = options['string_length']
    word = str(generator.get_min_value())
    repetitions = target_length // (len(word) + 1)
    ret = ' '.join([word] * repetitions)
    output.output([ret])
