#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *
from alipay.aop.api.domain.BelongMerchantInfoDTO import BelongMerchantInfoDTO


class AlipayCommerceEnergyReceiveSendModel(object):

    def __init__(self):
        self._alipay_uid = None
        self._belong_merchant_info = None
        self._get_time = None
        self._goods_id = None
        self._record_id = None
        self._trade_no = None

    @property
    def alipay_uid(self):
        return self._alipay_uid

    @alipay_uid.setter
    def alipay_uid(self, value):
        self._alipay_uid = value
    @property
    def belong_merchant_info(self):
        return self._belong_merchant_info

    @belong_merchant_info.setter
    def belong_merchant_info(self, value):
        if isinstance(value, BelongMerchantInfoDTO):
            self._belong_merchant_info = value
        else:
            self._belong_merchant_info = BelongMerchantInfoDTO.from_alipay_dict(value)
    @property
    def get_time(self):
        return self._get_time

    @get_time.setter
    def get_time(self, value):
        self._get_time = value
    @property
    def goods_id(self):
        return self._goods_id

    @goods_id.setter
    def goods_id(self, value):
        self._goods_id = value
    @property
    def record_id(self):
        return self._record_id

    @record_id.setter
    def record_id(self, value):
        self._record_id = value
    @property
    def trade_no(self):
        return self._trade_no

    @trade_no.setter
    def trade_no(self, value):
        self._trade_no = value


    def to_alipay_dict(self):
        params = dict()
        if self.alipay_uid:
            if hasattr(self.alipay_uid, 'to_alipay_dict'):
                params['alipay_uid'] = self.alipay_uid.to_alipay_dict()
            else:
                params['alipay_uid'] = self.alipay_uid
        if self.belong_merchant_info:
            if hasattr(self.belong_merchant_info, 'to_alipay_dict'):
                params['belong_merchant_info'] = self.belong_merchant_info.to_alipay_dict()
            else:
                params['belong_merchant_info'] = self.belong_merchant_info
        if self.get_time:
            if hasattr(self.get_time, 'to_alipay_dict'):
                params['get_time'] = self.get_time.to_alipay_dict()
            else:
                params['get_time'] = self.get_time
        if self.goods_id:
            if hasattr(self.goods_id, 'to_alipay_dict'):
                params['goods_id'] = self.goods_id.to_alipay_dict()
            else:
                params['goods_id'] = self.goods_id
        if self.record_id:
            if hasattr(self.record_id, 'to_alipay_dict'):
                params['record_id'] = self.record_id.to_alipay_dict()
            else:
                params['record_id'] = self.record_id
        if self.trade_no:
            if hasattr(self.trade_no, 'to_alipay_dict'):
                params['trade_no'] = self.trade_no.to_alipay_dict()
            else:
                params['trade_no'] = self.trade_no
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = AlipayCommerceEnergyReceiveSendModel()
        if 'alipay_uid' in d:
            o.alipay_uid = d['alipay_uid']
        if 'belong_merchant_info' in d:
            o.belong_merchant_info = d['belong_merchant_info']
        if 'get_time' in d:
            o.get_time = d['get_time']
        if 'goods_id' in d:
            o.goods_id = d['goods_id']
        if 'record_id' in d:
            o.record_id = d['record_id']
        if 'trade_no' in d:
            o.trade_no = d['trade_no']
        return o


