"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const defaults = require("@aws-solutions-constructs/core");
const app = new aws_cdk_lib_1.App();
// Empty arguments
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
const construct = new lib_1.KinesisFirehoseToAnalyticsAndS3(stack, 'test-kinesisfirehose-analytics-s3', {
    kinesisAnalyticsProps: {
        inputs: [{
                inputSchema: {
                    recordColumns: [{
                            name: 'ticker_symbol',
                            sqlType: 'VARCHAR(4)',
                            mapping: '$.ticker_symbol'
                        }, {
                            name: 'sector',
                            sqlType: 'VARCHAR(16)',
                            mapping: '$.sector'
                        }, {
                            name: 'change',
                            sqlType: 'REAL',
                            mapping: '$.change'
                        }, {
                            name: 'price',
                            sqlType: 'REAL',
                            mapping: '$.price'
                        }],
                    recordFormat: {
                        recordFormatType: 'JSON'
                    },
                    recordEncoding: 'UTF-8'
                },
                namePrefix: 'SOURCE_SQL_STREAM'
            }]
    },
    bucketProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
    },
    logS3AccessLogs: false
});
const s3Bucket = construct.s3Bucket;
defaults.addCfnSuppressRules(s3Bucket, [
    { id: 'W35',
        reason: 'This S3 bucket is created for unit/ integration testing purposes only.' },
]);
app.synth();
//# sourceMappingURL=data:application/json;base64,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