"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
// Definitions
const props = {
    kinesisAnalyticsProps: {
        inputs: [{
                inputSchema: {
                    recordColumns: [{
                            name: 'ticker_symbol',
                            sqlType: 'VARCHAR(4)',
                            mapping: '$.ticker_symbol'
                        }, {
                            name: 'sector',
                            sqlType: 'VARCHAR(16)',
                            mapping: '$.sector'
                        }, {
                            name: 'change',
                            sqlType: 'REAL',
                            mapping: '$.change'
                        }, {
                            name: 'price',
                            sqlType: 'REAL',
                            mapping: '$.price'
                        }],
                    recordFormat: {
                        recordFormatType: 'JSON'
                    },
                    recordEncoding: 'UTF-8'
                },
                namePrefix: 'SOURCE_SQL_STREAM'
            }]
    },
    bucketProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
    }
};
new lib_1.KinesisFirehoseToAnalyticsAndS3(stack, 'test-firehose-s3-and-analytics-stack', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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