import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * Represents a reference to a CodeDeploy Application deploying to Amazon ECS.
 *
 * If you're managing the Application alongside the rest of your CDK resources,
 * use the {@link EcsApplication} class.
 *
 * If you want to reference an already existing Application,
 * or one defined in a different CDK Stack,
 * use the {@link EcsApplication#fromEcsApplicationName} method.
 *
 * @stability stable
 */
export interface IEcsApplication extends IResource {
    /**
     * @stability stable
     * @attribute true
     */
    readonly applicationArn: string;
    /**
     * @stability stable
     * @attribute true
     */
    readonly applicationName: string;
}
/**
 * Construction properties for {@link EcsApplication}.
 *
 * @stability stable
 */
export interface EcsApplicationProps {
    /**
     * The physical, human-readable name of the CodeDeploy Application.
     *
     * @default an auto-generated name will be used
     * @stability stable
     */
    readonly applicationName?: string;
}
/**
 * A CodeDeploy Application that deploys to an Amazon ECS service.
 *
 * @stability stable
 * @resource AWS::CodeDeploy::Application
 */
export declare class EcsApplication extends Resource implements IEcsApplication {
    /**
     * Import an Application defined either outside the CDK, or in a different CDK Stack.
     *
     * @param scope the parent Construct for this new Construct.
     * @param id the logical ID of this new Construct.
     * @param ecsApplicationName the name of the application to import.
     * @returns a Construct representing a reference to an existing Application
     * @stability stable
     */
    static fromEcsApplicationName(scope: Construct, id: string, ecsApplicationName: string): IEcsApplication;
    /**
     * @stability stable
     */
    readonly applicationArn: string;
    /**
     * @stability stable
     */
    readonly applicationName: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: EcsApplicationProps);
}
