"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const path = require("path");
beforeAll(() => {
    child_process_1.spawnSync('docker', ['build', '-t', 'parcel', path.join(__dirname, '../parcel')]);
});
test('parcel is available', async () => {
    const proc = child_process_1.spawnSync('docker', [
        'run', 'parcel',
        'sh', '-c',
        '$(node -p "require.resolve(\'parcel\')") --version',
    ]);
    expect(proc.status).toEqual(0);
});
test('can npm install with non root user', async () => {
    const proc = child_process_1.spawnSync('docker', [
        'run', '-u', '1000:1000',
        'parcel',
        'sh', '-c', [
            'mkdir /tmp/test',
            'cd /tmp/test',
            'npm i constructs',
        ].join(' && '),
    ]);
    expect(proc.status).toEqual(0);
});
test('can yarn install with non root user', async () => {
    const proc = child_process_1.spawnSync('docker', [
        'run', '-u', '500:500',
        'parcel',
        'sh', '-c', [
            'mkdir /tmp/test',
            'cd /tmp/test',
            'yarn add constructs',
        ].join(' && '),
    ]);
    expect(proc.status).toEqual(0);
});
//# sourceMappingURL=data:application/json;base64,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