"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MappingTemplate = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
/**
 * MappingTemplates for AppSync resolvers
 */
class MappingTemplate {
    /**
     * Create a mapping template from the given string
     */
    static fromString(template) {
        return new StringMappingTemplate(template);
    }
    /**
     * Create a mapping template from the given file
     */
    static fromFile(fileName) {
        return new StringMappingTemplate(fs_1.readFileSync(fileName).toString('utf-8'));
    }
    /**
     * Mapping template for a result list from DynamoDB
     */
    static dynamoDbResultList() {
        return this.fromString('$util.toJson($ctx.result.items)');
    }
    /**
     * Mapping template for a single result item from DynamoDB
     */
    static dynamoDbResultItem() {
        return this.fromString('$util.toJson($ctx.result)');
    }
    /**
     * Mapping template to scan a DynamoDB table to fetch all entries
     */
    static dynamoDbScanTable(consistentRead = false) {
        return this.fromString(`{"version" : "2017-02-28", "operation" : "Scan", "consistentRead": ${consistentRead}}`);
    }
    /**
     * Mapping template to query a set of items from a DynamoDB table
     *
     * @param cond the key condition for the query
     */
    static dynamoDbQuery(cond, indexName, consistentRead = false) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_KeyCondition(cond);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.dynamoDbQuery);
            }
            throw error;
        }
        return this.fromString(`{"version" : "2017-02-28", "operation" : "Query",  "consistentRead": ${consistentRead}, ${indexName ? `"index" : "${indexName}", ` : ''}${cond.renderTemplate()}}`);
    }
    /**
     * Mapping template to get a single item from a DynamoDB table
     *
     * @param keyName the name of the hash key field
     * @param idArg the name of the Query argument
     */
    static dynamoDbGetItem(keyName, idArg, consistentRead = false) {
        return this.fromString(`{"version": "2017-02-28", "operation": "GetItem", "consistentRead": ${consistentRead}, "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * Mapping template to delete a single item from a DynamoDB table
     *
     * @param keyName the name of the hash key field
     * @param idArg the name of the Mutation argument
     */
    static dynamoDbDeleteItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "DeleteItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * Mapping template to save a single item to a DynamoDB table
     *
     * @param key the assigment of Mutation values to the primary key
     * @param values the assignment of Mutation values to the table attributes
     */
    static dynamoDbPutItem(key, values) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_PrimaryKey(key);
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_AttributeValues(values);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.dynamoDbPutItem);
            }
            throw error;
        }
        return this.fromString(`
      ${values.renderVariables()}
      {
        "version": "2017-02-28",
        "operation": "PutItem",
        ${key.renderTemplate()},
        ${values.renderTemplate()}
      }`);
    }
    /**
     * Mapping template to invoke a Lambda function
     *
     * @param payload the VTL template snippet of the payload to send to the lambda.
     * If no payload is provided all available context fields are sent to the Lambda function
     * @param operation the type of operation AppSync should perform on the data source
     */
    static lambdaRequest(payload = '$util.toJson($ctx)', operation = 'Invoke') {
        return this.fromString(`{"version": "2017-02-28", "operation": "${operation}", "payload": ${payload}}`);
    }
    /**
     * Mapping template to return the Lambda result to the caller
     */
    static lambdaResult() {
        return this.fromString('$util.toJson($ctx.result)');
    }
}
exports.MappingTemplate = MappingTemplate;
_a = JSII_RTTI_SYMBOL_1;
MappingTemplate[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.MappingTemplate", version: "2.50.0-alpha.0" };
class StringMappingTemplate extends MappingTemplate {
    constructor(template) {
        super();
        this.template = template;
    }
    renderTemplate() {
        return this.template;
    }
}
//# sourceMappingURL=data:application/json;base64,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