# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.menu_form import MenuForm


class MenuOption(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    MenuOption - a model defined in OpenAPI
        name: Menu option name (unique identifier).
        title: Menu option title.
        description: Additional descriptive text for menu option [Optional].
        disabled: Whether to show option as disabled [Optional].
        form: The form of this MenuOption [Optional].
    """

    name: str
    title: str
    description: Optional[str] = None
    disabled: Optional[bool] = None
    form: Optional[MenuForm] = None

    def __init__(
        self,
        *,
        name: str = None,
        title: str = None,
        description: Optional[str] = None,
        disabled: Optional[bool] = None,
        form: Optional[MenuForm] = None,
        **kwargs,
    ):
        super().__init__(
            description=description,
            disabled=disabled,
            form=form,
            name=name,
            title=title,
            **kwargs,
        )

    class Config:
        allow_population_by_field_name = True


MenuOption.update_forward_refs()
