# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.indy_proof_requested_proof_predicate import (
    IndyProofRequestedProofPredicate,
)
from aries_cloudcontroller.model.indy_proof_requested_proof_revealed_attr import (
    IndyProofRequestedProofRevealedAttr,
)
from aries_cloudcontroller.model.indy_proof_requested_proof_revealed_attr_group import (
    IndyProofRequestedProofRevealedAttrGroup,
)


class IndyProofRequestedProof(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    IndyProofRequestedProof - a model defined in OpenAPI
        predicates: Proof requested proof predicates. [Optional].
        revealed_attr_groups: Proof requested proof revealed attribute groups [Optional].
        revealed_attrs: Proof requested proof revealed attributes [Optional].
        self_attested_attrs: Proof requested proof self-attested attributes [Optional].
        unrevealed_attrs: Unrevealed attributes [Optional].
    """

    predicates: Optional[Dict[str, IndyProofRequestedProofPredicate]] = None
    revealed_attr_groups: Optional[
        Dict[str, IndyProofRequestedProofRevealedAttrGroup]
    ] = None
    revealed_attrs: Optional[Dict[str, IndyProofRequestedProofRevealedAttr]] = None
    self_attested_attrs: Optional[Dict[str, Any]] = None
    unrevealed_attrs: Optional[Dict[str, Any]] = None

    def __init__(
        self,
        *,
        predicates: Optional[Dict[str, IndyProofRequestedProofPredicate]] = None,
        revealed_attr_groups: Optional[
            Dict[str, IndyProofRequestedProofRevealedAttrGroup]
        ] = None,
        revealed_attrs: Optional[Dict[str, IndyProofRequestedProofRevealedAttr]] = None,
        self_attested_attrs: Optional[Dict[str, Any]] = None,
        unrevealed_attrs: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        super().__init__(
            predicates=predicates,
            revealed_attr_groups=revealed_attr_groups,
            revealed_attrs=revealed_attrs,
            self_attested_attrs=self_attested_attrs,
            unrevealed_attrs=unrevealed_attrs,
            **kwargs,
        )

    class Config:
        allow_population_by_field_name = True


IndyProofRequestedProof.update_forward_refs()
