# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class EndpointsResult(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    EndpointsResult - a model defined in OpenAPI
        my_endpoint: My endpoint [Optional].
        their_endpoint: Their endpoint [Optional].
    """

    my_endpoint: Optional[str] = None
    their_endpoint: Optional[str] = None

    def __init__(
        self,
        *,
        my_endpoint: Optional[str] = None,
        their_endpoint: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            my_endpoint=my_endpoint,
            their_endpoint=their_endpoint,
            **kwargs,
        )

    @validator("my_endpoint")
    def my_endpoint_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[A-Za-z0-9\.\-\+]+:\/\/([A-Za-z0-9][.A-Za-z0-9-_]+[A-Za-z0-9])+(:[1-9][0-9]*)?(\/[^?&#]+)?$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of my_endpoint does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("their_endpoint")
    def their_endpoint_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[A-Za-z0-9\.\-\+]+:\/\/([A-Za-z0-9][.A-Za-z0-9-_]+[A-Za-z0-9])+(:[1-9][0-9]*)?(\/[^?&#]+)?$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of their_endpoint does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


EndpointsResult.update_forward_refs()
