# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class CredentialDefinitionSendResult(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    CredentialDefinitionSendResult - a model defined in OpenAPI
        credential_definition_id: Credential definition identifier.
    """

    credential_definition_id: str

    def __init__(
        self,
        *,
        credential_definition_id: str = None,
        **kwargs,
    ):
        super().__init__(
            credential_definition_id=credential_definition_id,
            **kwargs,
        )

    @validator("credential_definition_id")
    def credential_definition_id_pattern(cls, value):

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+)):(.+)?$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of credential_definition_id does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


CredentialDefinitionSendResult.update_forward_refs()
