# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.attach_decorator_data import AttachDecoratorData


class AttachDecorator(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    AttachDecorator - a model defined in OpenAPI
        data: The data of this AttachDecorator.
        id: Attachment identifier [Optional].
        byte_count: Byte count of data included by reference [Optional].
        description: Human-readable description of content [Optional].
        filename: File name [Optional].
        lastmod_time: Hint regarding last modification datetime, in ISO-8601 format [Optional].
        mime_type: MIME type [Optional].
    """

    data: AttachDecoratorData
    id: Optional[str] = Field(None, alias="@id")
    byte_count: Optional[int] = None
    description: Optional[str] = None
    filename: Optional[str] = None
    lastmod_time: Optional[str] = None
    mime_type: Optional[str] = Field(None, alias="mime-type")

    def __init__(
        self,
        *,
        data: AttachDecoratorData = None,
        id: Optional[str] = None,
        byte_count: Optional[int] = None,
        description: Optional[str] = None,
        filename: Optional[str] = None,
        lastmod_time: Optional[str] = None,
        mime_type: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            id=id,
            byte_count=byte_count,
            data=data,
            description=description,
            filename=filename,
            lastmod_time=lastmod_time,
            mime_type=mime_type,
            **kwargs,
        )

    @validator("lastmod_time")
    def lastmod_time_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^\d{4}-\d\d-\d\d[T ]\d\d:\d\d(?:\:(?:\d\d(?:\.\d{1,6})?))?(?:[+-]\d\d:?\d\d|Z|)$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of lastmod_time does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


AttachDecorator.update_forward_refs()
