import * as lambda from '@aws-cdk/aws-lambda';
/**
 * Dependency files to exclude from the asset hash.
 */
export declare const DEPENDENCY_EXCLUDES: string[];
/**
 * The location in the image that the bundler image caches dependencies.
 */
export declare const BUNDLER_DEPENDENCIES_CACHE = "/var/dependencies";
/**
 * Options for bundling
 */
export interface BundlingOptions {
    /**
     * Entry path
     */
    readonly entry: string;
    /**
     * The runtime of the lambda function
     */
    readonly runtime: lambda.Runtime;
    /**
     * Output path suffix ('python' for a layer, '.' otherwise)
     */
    readonly outputPathSuffix: string;
}
/**
 * Produce bundled Lambda asset code
 */
export declare function bundle(options: BundlingOptions): lambda.AssetCode;
/**
 * Checks to see if the `entry` directory contains a type of dependency that
 * we know how to install.
 */
export declare function hasDependencies(entry: string): boolean;
