# coding: utf-8

"""
    ARLAS Tagger API

    (Un)Tag fields of ARLAS collections

    OpenAPI spec version: 20.0.0
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class StatusApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def tagging_get(self, collection, id, **kwargs):
        """
        TagStatus
        Get the status of the (un)tagging operation, given the id of a previously requested operation
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.tagging_get(collection, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param str id: The id of a previously requested (un)tag operation. (required)
        :param bool pretty: Pretty print
        :return: UpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.tagging_get_with_http_info(collection, id, **kwargs)
        else:
            (data) = self.tagging_get_with_http_info(collection, id, **kwargs)
            return data

    def tagging_get_with_http_info(self, collection, id, **kwargs):
        """
        TagStatus
        Get the status of the (un)tagging operation, given the id of a previously requested operation
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.tagging_get_with_http_info(collection, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param str id: The id of a previously requested (un)tag operation. (required)
        :param bool pretty: Pretty print
        :return: UpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'id', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tagging_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `tagging_get`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `tagging_get`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/status/{collection}/_tag/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UpdateResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def tagging_get_list(self, collection, **kwargs):
        """
        TagList
        Get the list of previously submitted tag requests
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.tagging_get_list(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param bool pretty: Pretty print
        :return: list[TagRefRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.tagging_get_list_with_http_info(collection, **kwargs)
        else:
            (data) = self.tagging_get_list_with_http_info(collection, **kwargs)
            return data

    def tagging_get_list_with_http_info(self, collection, **kwargs):
        """
        TagList
        Get the list of previously submitted tag requests
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.tagging_get_list_with_http_info(collection, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str collection: collection (required)
        :param bool pretty: Pretty print
        :return: list[TagRefRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tagging_get_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params) or (params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `tagging_get_list`")


        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/status/{collection}/_taglist', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[TagRefRequest]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
