# Generated by Django 3.2.4 on 2021-08-16 05:30

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


def move_existing_run_numbers(apps, _):
    """Moves the run_number field data into the now related RunNumber model"""
    ReductionRun = apps.get_model("reduction_viewer", "ReductionRun")
    RunNumber = apps.get_model("reduction_viewer", "RunNumber")

    for run in ReductionRun.objects.all():
        RunNumber.objects.create(reduction_run=run, run_number=run.run_number)


class Migration(migrations.Migration):

    dependencies = [
        ('reduction_viewer', '0006_reductionrun_reduction_host'),
    ]

    operations = [
        migrations.CreateModel(
            name='RunNumber',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('run_number', models.IntegerField(validators=[django.core.validators.MinValueValidator(0)])),
                ('reduction_run',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                   related_name='run_numbers',
                                   to='reduction_viewer.reductionrun')),
            ],
        ),
        migrations.RunPython(move_existing_run_numbers),
        migrations.RemoveField(
            model_name='reductionrun',
            name='run_number',
        ),
    ]
