# Generated by Django 1.10.1 on 2016-09-09 23:11
from __future__ import unicode_literals

from django.db import migrations

def delete_permissions(apps, schema_editor):
    User = apps.get_model('auth', 'User')
    ContentType = apps.get_model('contenttypes', 'ContentType')
    Permission = apps.get_model('auth', 'Permission')
    ct = ContentType.objects.get_for_model(User)
    Permission.objects.filter(content_type=ct).filter(codename__in=['member', 'blue_member', 'signature_management', 'signature_view']).delete()

def create_permissions(apps, schema_editor):
    User = apps.get_model('auth', 'User')
    ContentType = apps.get_model('contenttypes', 'ContentType')
    Permission = apps.get_model('auth', 'Permission')
    ct = ContentType.objects.get_for_model(User)
    Permission.objects.get_or_create(codename="member", content_type=ct, name="member")
    Permission.objects.get_or_create(codename="blue_member", content_type=ct, name="blue_member")


class Migration(migrations.Migration):

    dependencies = [
        ('authentication', '0004_create_permissions'),
    ]

    operations = [
        migrations.RunPython(delete_permissions, create_permissions),
    ]
