# Generated by Django 3.0.8 on 2020-09-29 06:27

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import multiselectfield.db.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('argus_auth', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Timeslot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=40)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='timeslots', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='NotificationProfile',
            fields=[
                ('timeslot', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='notification_profile', serialize=False, to='argus_notificationprofile.Timeslot')),
                ('media', multiselectfield.db.fields.MultiSelectField(choices=[('EM', 'Email'), ('SM', 'SMS')], default=['EM'], max_length=5)),
                ('active', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='TimeRecurrence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('days', multiselectfield.db.fields.MultiSelectField(choices=[(1, 'Monday'), (2, 'Tuesday'), (3, 'Wednesday'), (4, 'Thursday'), (5, 'Friday'), (6, 'Saturday'), (7, 'Sunday')], max_length=13)),
                ('start', models.TimeField(help_text='Local time.')),
                ('end', models.TimeField(help_text='Local time.')),
                ('timeslot', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='time_recurrences', to='argus_notificationprofile.Timeslot')),
            ],
        ),
        migrations.CreateModel(
            name='Filter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=40)),
                ('filter_string', models.TextField()),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='filters', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddConstraint(
            model_name='timeslot',
            constraint=models.UniqueConstraint(fields=('name', 'user'), name='timeslot_unique_name_per_user'),
        ),
        migrations.AddField(
            model_name='notificationprofile',
            name='filters',
            field=models.ManyToManyField(related_name='notification_profiles', to='argus_notificationprofile.Filter'),
        ),
        migrations.AddField(
            model_name='notificationprofile',
            name='phone_number',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='argus_auth.PhoneNumber'),
        ),
        migrations.AddField(
            model_name='notificationprofile',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notification_profiles', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddConstraint(
            model_name='filter',
            constraint=models.UniqueConstraint(fields=('name', 'user'), name='filter_unique_name_per_user'),
        ),
    ]
