"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53ToAlb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const defaults = require("@aws-solutions-constructs/core");
const r53 = require("@aws-cdk/aws-route53");
const r53t = require("@aws-cdk/aws-route53-targets");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
/**
 * @summary Configures a Route53 Hosted Zone to route to an Application Load Balancer
 */
class Route53ToAlb extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the Route53ToAlb class.
     * @access public
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        defaults.CheckProps(props);
        // NOTE: We don't call CheckAlbProps() here, because this construct creates an ALB
        // with no listener or target, so some of those checks don't apply
        if ((_b = props === null || props === void 0 ? void 0 : props.loadBalancerProps) === null || _b === void 0 ? void 0 : _b.vpc) {
            throw new Error('Specify any existing VPC at the construct level, not within loadBalancerProps.');
        }
        if (props.existingLoadBalancerObj && !props.existingVpc) {
            throw new Error('An existing ALB already exists in a VPC, so that VPC must be passed to the construct in props.existingVpc');
        }
        if (props.existingHostedZoneInterface && !props.publicApi && !props.existingVpc) {
            throw new Error('An existing Private Hosted Zone already exists in a VPC, so that VPC must be passed to the construct in props.existingVpc');
        }
        if (props.existingVpc) {
            this.vpc = props.existingVpc;
        }
        else {
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: props.publicApi ?
                    defaults.DefaultPublicPrivateVpcProps() :
                    // If this is an internal app, we're going to turn on DNS
                    // by default to allow gateway and interface service endpoints
                    defaults.overrideProps(defaults.DefaultIsolatedVpcProps(), { enableDnsHostnames: true, enableDnsSupport: true, }),
                userVpcProps: props.vpcProps,
            });
        }
        if (props.existingHostedZoneInterface) {
            this.hostedZone = props.existingHostedZoneInterface;
        }
        else {
            if (props.publicApi) {
                throw new Error('Public APIs require an existingHostedZone be passed in the Props object.');
            }
            else {
                if (!props.privateHostedZoneProps) {
                    throw new Error('Must supply privateHostedZoneProps to create a private API');
                }
                if (props.privateHostedZoneProps.vpc) {
                    throw new Error('All VPC specs must be provided at the Construct level in Route53ToAlbProps');
                }
                const manufacturedProps = defaults.overrideProps(props.privateHostedZoneProps, { vpc: this.vpc });
                this.hostedZone = new r53.PrivateHostedZone(this, `${id}-zone`, manufacturedProps);
            }
        }
        this.loadBalancer = defaults.ObtainAlb(this, id, this.vpc, props.publicApi, props.existingLoadBalancerObj, props.loadBalancerProps, props.logAlbAccessLogs, props.albLoggingBucketProps);
        // Add the ALB to the HostedZone as a target
        const hostedZoneTarget = new r53t.LoadBalancerTarget(this.loadBalancer);
        new r53.ARecord(this, `${id}-alias`, {
            target: { aliasTarget: hostedZoneTarget },
            zone: this.hostedZone
        });
    }
}
exports.Route53ToAlb = Route53ToAlb;
_a = JSII_RTTI_SYMBOL_1;
Route53ToAlb[_a] = { fqn: "@aws-solutions-constructs/aws-route53-alb.Route53ToAlb", version: "1.138.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBOzs7Ozs7Ozs7OztHQVdHO0FBRUgsVUFBVTtBQUNWLDJEQUEyRDtBQUczRCw0Q0FBNEM7QUFDNUMscURBQXFEO0FBQ3JELHdGQUF3RjtBQUN4Rix3Q0FBMEM7Ozs7QUF5QjFDLE1BQWEsWUFBYSxTQUFRLGdCQUFTOzs7Ozs7OztJQU16QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCOztRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLFFBQVEsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFM0Isa0ZBQWtGO1FBQ2xGLGtFQUFrRTtRQUNsRSxVQUFJLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxpQkFBaUIsMENBQUUsR0FBRyxFQUFFO1lBQ2pDLE1BQU0sSUFBSSxLQUFLLENBQUMsZ0ZBQWdGLENBQUMsQ0FBQztTQUNuRztRQUVELElBQUksS0FBSyxDQUFDLHVCQUF1QixJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsRUFBRTtZQUN2RCxNQUFNLElBQUksS0FBSyxDQUFDLDJHQUEyRyxDQUFDLENBQUM7U0FDOUg7UUFFRCxJQUFJLEtBQUssQ0FBQywyQkFBMkIsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxFQUFFO1lBQy9FLE1BQU0sSUFBSSxLQUFLLENBQUMsMkhBQTJILENBQUMsQ0FBQztTQUM5STtRQUVELElBQUksS0FBSyxDQUFDLFdBQVcsRUFBRTtZQUNyQixJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7U0FDOUI7YUFBTTtZQUNMLElBQUksQ0FBQyxHQUFHLEdBQUcsUUFBUSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUU7Z0JBQ2xDLGVBQWUsRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUM7b0JBQ2hDLFFBQVEsQ0FBQyw0QkFBNEIsRUFBRSxDQUFDLENBQUM7b0JBQ3pDLHlEQUF5RDtvQkFDekQsOERBQThEO29CQUM5RCxRQUFRLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyx1QkFBdUIsRUFBRSxFQUFFLEVBQUUsa0JBQWtCLEVBQUUsSUFBSSxFQUFFLGdCQUFnQixFQUFFLElBQUksR0FBRyxDQUFDO2dCQUNuSCxZQUFZLEVBQUUsS0FBSyxDQUFDLFFBQVE7YUFDN0IsQ0FBQyxDQUFDO1NBQ0o7UUFFRCxJQUFJLEtBQUssQ0FBQywyQkFBMkIsRUFBRTtZQUNyQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQywyQkFBMkIsQ0FBQztTQUNyRDthQUFNO1lBQ0wsSUFBSSxLQUFLLENBQUMsU0FBUyxFQUFFO2dCQUNuQixNQUFNLElBQUksS0FBSyxDQUFDLDBFQUEwRSxDQUFDLENBQUM7YUFDN0Y7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLEtBQUssQ0FBQyxzQkFBc0IsRUFBRTtvQkFDakMsTUFBTSxJQUFJLEtBQUssQ0FBQyw0REFBNEQsQ0FBQyxDQUFDO2lCQUMvRTtnQkFDRCxJQUFJLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQyxHQUFHLEVBQUU7b0JBQ3BDLE1BQU0sSUFBSSxLQUFLLENBQUMsNEVBQTRFLENBQUMsQ0FBQztpQkFDL0Y7Z0JBQ0QsTUFBTSxpQkFBaUIsR0FBK0IsUUFBUSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsc0JBQXNCLEVBQUUsRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUM7Z0JBQzlILElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsSUFBSSxFQUFFLEdBQUcsRUFBRSxPQUFPLEVBQUUsaUJBQWlCLENBQUMsQ0FBQzthQUNwRjtTQUNGO1FBRUQsSUFBSSxDQUFDLFlBQVksR0FBRyxRQUFRLENBQUMsU0FBUyxDQUNwQyxJQUFJLEVBQ0osRUFBRSxFQUNGLElBQUksQ0FBQyxHQUFHLEVBQ1IsS0FBSyxDQUFDLFNBQVMsRUFDZixLQUFLLENBQUMsdUJBQXVCLEVBQzdCLEtBQUssQ0FBQyxpQkFBaUIsRUFDdkIsS0FBSyxDQUFDLGdCQUFnQixFQUN0QixLQUFLLENBQUMscUJBQXFCLENBQzVCLENBQUM7UUFFRiw0Q0FBNEM7UUFDNUMsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7UUFFeEUsSUFBSSxHQUFHLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxHQUFHLEVBQUUsUUFBUSxFQUFFO1lBQ25DLE1BQU0sRUFBRSxFQUFFLFdBQVcsRUFBRSxnQkFBZ0IsRUFBRTtZQUN6QyxJQUFJLEVBQUUsSUFBSSxDQUFDLFVBQVU7U0FDdEIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF4RUgsb0NBeUVDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IDIwMjIgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG4vLyBJbXBvcnRzXG5pbXBvcnQgKiBhcyBkZWZhdWx0cyBmcm9tIFwiQGF3cy1zb2x1dGlvbnMtY29uc3RydWN0cy9jb3JlXCI7XG5pbXBvcnQgKiBhcyBlbGIgZnJvbSBcIkBhd3MtY2RrL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyXCI7XG5pbXBvcnQgKiBhcyBzMyBmcm9tIFwiQGF3cy1jZGsvYXdzLXMzXCI7XG5pbXBvcnQgKiBhcyByNTMgZnJvbSBcIkBhd3MtY2RrL2F3cy1yb3V0ZTUzXCI7XG5pbXBvcnQgKiBhcyByNTN0IGZyb20gJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzLXRhcmdldHMnO1xuLy8gTm90ZTogVG8gZW5zdXJlIENES3YyIGNvbXBhdGliaWxpdHksIGtlZXAgdGhlIGltcG9ydCBzdGF0ZW1lbnQgZm9yIENvbnN0cnVjdCBzZXBhcmF0ZVxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBlYzIgZnJvbSAnQGF3cy1jZGsvYXdzLWVjMic7XG5cbmV4cG9ydCBpbnRlcmZhY2UgUm91dGU1M1RvQWxiUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJpdmF0ZUhvc3RlZFpvbmVQcm9wcz86IHI1My5Qcml2YXRlSG9zdGVkWm9uZVByb3BzIHwgYW55LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGV4aXN0aW5nSG9zdGVkWm9uZUludGVyZmFjZT86IHI1My5JSG9zdGVkWm9uZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBsb2FkQmFsYW5jZXJQcm9wcz86IGVsYi5BcHBsaWNhdGlvbkxvYWRCYWxhbmNlclByb3BzIHwgYW55LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBleGlzdGluZ0xvYWRCYWxhbmNlck9iaj86IGVsYi5BcHBsaWNhdGlvbkxvYWRCYWxhbmNlcixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGxvZ0FsYkFjY2Vzc0xvZ3M/OiBib29sZWFuLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFsYkxvZ2dpbmdCdWNrZXRQcm9wcz86IHMzLkJ1Y2tldFByb3BzLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdnBjUHJvcHM/OiBlYzIuVnBjUHJvcHMsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBleGlzdGluZ1ZwYz86IGVjMi5JVnBjLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHB1YmxpY0FwaTogYm9vbGVhblxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBSb3V0ZTUzVG9BbGIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgaG9zdGVkWm9uZTogcjUzLklIb3N0ZWRab25lO1xuICBwdWJsaWMgcmVhZG9ubHkgdnBjOiBlYzIuSVZwYztcbiAgcHVibGljIHJlYWRvbmx5IGxvYWRCYWxhbmNlcjogZWxiLkFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJvdXRlNTNUb0FsYlByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBkZWZhdWx0cy5DaGVja1Byb3BzKHByb3BzKTtcblxuICAgIC8vIE5PVEU6IFdlIGRvbid0IGNhbGwgQ2hlY2tBbGJQcm9wcygpIGhlcmUsIGJlY2F1c2UgdGhpcyBjb25zdHJ1Y3QgY3JlYXRlcyBhbiBBTEJcbiAgICAvLyB3aXRoIG5vIGxpc3RlbmVyIG9yIHRhcmdldCwgc28gc29tZSBvZiB0aG9zZSBjaGVja3MgZG9uJ3QgYXBwbHlcbiAgICBpZiAocHJvcHM/LmxvYWRCYWxhbmNlclByb3BzPy52cGMpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignU3BlY2lmeSBhbnkgZXhpc3RpbmcgVlBDIGF0IHRoZSBjb25zdHJ1Y3QgbGV2ZWwsIG5vdCB3aXRoaW4gbG9hZEJhbGFuY2VyUHJvcHMuJyk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLmV4aXN0aW5nTG9hZEJhbGFuY2VyT2JqICYmICFwcm9wcy5leGlzdGluZ1ZwYykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdBbiBleGlzdGluZyBBTEIgYWxyZWFkeSBleGlzdHMgaW4gYSBWUEMsIHNvIHRoYXQgVlBDIG11c3QgYmUgcGFzc2VkIHRvIHRoZSBjb25zdHJ1Y3QgaW4gcHJvcHMuZXhpc3RpbmdWcGMnKTtcbiAgICB9XG5cbiAgICBpZiAocHJvcHMuZXhpc3RpbmdIb3N0ZWRab25lSW50ZXJmYWNlICYmICFwcm9wcy5wdWJsaWNBcGkgJiYgIXByb3BzLmV4aXN0aW5nVnBjKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0FuIGV4aXN0aW5nIFByaXZhdGUgSG9zdGVkIFpvbmUgYWxyZWFkeSBleGlzdHMgaW4gYSBWUEMsIHNvIHRoYXQgVlBDIG11c3QgYmUgcGFzc2VkIHRvIHRoZSBjb25zdHJ1Y3QgaW4gcHJvcHMuZXhpc3RpbmdWcGMnKTtcbiAgICB9XG5cbiAgICBpZiAocHJvcHMuZXhpc3RpbmdWcGMpIHtcbiAgICAgIHRoaXMudnBjID0gcHJvcHMuZXhpc3RpbmdWcGM7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMudnBjID0gZGVmYXVsdHMuYnVpbGRWcGMoc2NvcGUsIHtcbiAgICAgICAgZGVmYXVsdFZwY1Byb3BzOiBwcm9wcy5wdWJsaWNBcGkgP1xuICAgICAgICAgIGRlZmF1bHRzLkRlZmF1bHRQdWJsaWNQcml2YXRlVnBjUHJvcHMoKSA6XG4gICAgICAgICAgLy8gSWYgdGhpcyBpcyBhbiBpbnRlcm5hbCBhcHAsIHdlJ3JlIGdvaW5nIHRvIHR1cm4gb24gRE5TXG4gICAgICAgICAgLy8gYnkgZGVmYXVsdCB0byBhbGxvdyBnYXRld2F5IGFuZCBpbnRlcmZhY2Ugc2VydmljZSBlbmRwb2ludHNcbiAgICAgICAgICBkZWZhdWx0cy5vdmVycmlkZVByb3BzKGRlZmF1bHRzLkRlZmF1bHRJc29sYXRlZFZwY1Byb3BzKCksIHsgZW5hYmxlRG5zSG9zdG5hbWVzOiB0cnVlLCBlbmFibGVEbnNTdXBwb3J0OiB0cnVlLCB9KSxcbiAgICAgICAgdXNlclZwY1Byb3BzOiBwcm9wcy52cGNQcm9wcyxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIGlmIChwcm9wcy5leGlzdGluZ0hvc3RlZFpvbmVJbnRlcmZhY2UpIHtcbiAgICAgIHRoaXMuaG9zdGVkWm9uZSA9IHByb3BzLmV4aXN0aW5nSG9zdGVkWm9uZUludGVyZmFjZTtcbiAgICB9IGVsc2Uge1xuICAgICAgaWYgKHByb3BzLnB1YmxpY0FwaSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ1B1YmxpYyBBUElzIHJlcXVpcmUgYW4gZXhpc3RpbmdIb3N0ZWRab25lIGJlIHBhc3NlZCBpbiB0aGUgUHJvcHMgb2JqZWN0LicpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgaWYgKCFwcm9wcy5wcml2YXRlSG9zdGVkWm9uZVByb3BzKSB7XG4gICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdNdXN0IHN1cHBseSBwcml2YXRlSG9zdGVkWm9uZVByb3BzIHRvIGNyZWF0ZSBhIHByaXZhdGUgQVBJJyk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHByb3BzLnByaXZhdGVIb3N0ZWRab25lUHJvcHMudnBjKSB7XG4gICAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdBbGwgVlBDIHNwZWNzIG11c3QgYmUgcHJvdmlkZWQgYXQgdGhlIENvbnN0cnVjdCBsZXZlbCBpbiBSb3V0ZTUzVG9BbGJQcm9wcycpO1xuICAgICAgICB9XG4gICAgICAgIGNvbnN0IG1hbnVmYWN0dXJlZFByb3BzOiByNTMuUHJpdmF0ZUhvc3RlZFpvbmVQcm9wcyA9IGRlZmF1bHRzLm92ZXJyaWRlUHJvcHMocHJvcHMucHJpdmF0ZUhvc3RlZFpvbmVQcm9wcywgeyB2cGM6IHRoaXMudnBjIH0pO1xuICAgICAgICB0aGlzLmhvc3RlZFpvbmUgPSBuZXcgcjUzLlByaXZhdGVIb3N0ZWRab25lKHRoaXMsIGAke2lkfS16b25lYCwgbWFudWZhY3R1cmVkUHJvcHMpO1xuICAgICAgfVxuICAgIH1cblxuICAgIHRoaXMubG9hZEJhbGFuY2VyID0gZGVmYXVsdHMuT2J0YWluQWxiKFxuICAgICAgdGhpcyxcbiAgICAgIGlkLFxuICAgICAgdGhpcy52cGMsXG4gICAgICBwcm9wcy5wdWJsaWNBcGksXG4gICAgICBwcm9wcy5leGlzdGluZ0xvYWRCYWxhbmNlck9iaixcbiAgICAgIHByb3BzLmxvYWRCYWxhbmNlclByb3BzLFxuICAgICAgcHJvcHMubG9nQWxiQWNjZXNzTG9ncyxcbiAgICAgIHByb3BzLmFsYkxvZ2dpbmdCdWNrZXRQcm9wc1xuICAgICk7XG5cbiAgICAvLyBBZGQgdGhlIEFMQiB0byB0aGUgSG9zdGVkWm9uZSBhcyBhIHRhcmdldFxuICAgIGNvbnN0IGhvc3RlZFpvbmVUYXJnZXQgPSBuZXcgcjUzdC5Mb2FkQmFsYW5jZXJUYXJnZXQodGhpcy5sb2FkQmFsYW5jZXIpO1xuXG4gICAgbmV3IHI1My5BUmVjb3JkKHRoaXMsIGAke2lkfS1hbGlhc2AsIHtcbiAgICAgIHRhcmdldDogeyBhbGlhc1RhcmdldDogaG9zdGVkWm9uZVRhcmdldCB9LFxuICAgICAgem9uZTogdGhpcy5ob3N0ZWRab25lXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==