/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as elb from "@aws-cdk/aws-elasticloadbalancingv2";
import * as s3 from "@aws-cdk/aws-s3";
import * as r53 from "@aws-cdk/aws-route53";
import { Construct } from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
export interface Route53ToAlbProps {
    /**
     * Custom properties for a new Private Hosted Zone.
     *
     * Cannot be specified for a
     * public API. Cannot specify a VPC
     *
     * @default - None
     */
    readonly privateHostedZoneProps?: r53.PrivateHostedZoneProps | any;
    /**
     * Existing Public or Private Hosted Zone.
     *
     * If a Private Hosted Zone, must
     * exist in the same VPC specified in existingVpc
     *
     * @default - None
     */
    readonly existingHostedZoneInterface?: r53.IHostedZone;
    /**
     * Custom properties for a new ALB.
     *
     * Providing both this and existingLoadBalancerObj
     * is an error. These properties cannot include a VPC.
     *
     * @default - None
     */
    readonly loadBalancerProps?: elb.ApplicationLoadBalancerProps | any;
    /**
     * An existing Application Load Balancer.
     *
     * Providing both this and loadBalancerProps
     * is an error. This ALB must exist in the same VPC specified in existingVPC
     *
     * @default - None
     */
    readonly existingLoadBalancerObj?: elb.ApplicationLoadBalancer;
    /**
     * Whether to turn on Access Logs for the Application Load Balancer.
     *
     * Uses an S3 bucket
     * with associated storage costs. Enabling Access Logging is a best practice.
     *
     * @default - true
     */
    readonly logAlbAccessLogs?: boolean;
    /**
     * Optional properties to customize the bucket used to store the ALB Access Logs.
     *
     * Supplying this and setting logAccessLogs to false is an error.
     *
     * @default - none
     */
    readonly albLoggingBucketProps?: s3.BucketProps;
    /**
     * Custom properties for a new VPC.
     *
     * Providing both this and existingVpc is
     * an error. If an existingAlb or existing Private Hosted Zone is provided, those
     * already exist in a VPC so this value cannot be provided.
     *
     * @default - None
     */
    readonly vpcProps?: ec2.VpcProps;
    /**
     * An existing VPC.
     *
     * Providing both this and vpcProps is an error. If an existingAlb or existing
     * Private Hosted Zone is provided, this value must be the VPC associated with those resources.
     *
     * @default - None
     */
    readonly existingVpc?: ec2.IVpc;
    /**
     * Whether to create a public or private API.
     *
     * This value has implications
     * for the VPC, the type of Hosted Zone and the Application Load Balancer
     *
     * @default - None
     */
    readonly publicApi: boolean;
}
/**
 * @summary Configures a Route53 Hosted Zone to route to an Application Load Balancer
 */
export declare class Route53ToAlb extends Construct {
    readonly hostedZone: r53.IHostedZone;
    readonly vpc: ec2.IVpc;
    readonly loadBalancer: elb.ApplicationLoadBalancer;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the Route53ToAlb class.
     * @access public
     */
    constructor(scope: Construct, id: string, props: Route53ToAlbProps);
}
