# Copyright 2017, 2020 Andrzej Cichocki

# This file is part of aridity.
#
# aridity is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# aridity is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with aridity.  If not, see <http://www.gnu.org/licenses/>.

from .repl import Repl
import os, sys

def main_processtemplate():
    'Process the given template to stdout using config from stdin.'
    templatepath, = sys.argv[1:]
    with Repl() as repl:
        for line in sys.stdin:
            repl(line)
        repl.printf("< %s", os.path.abspath(templatepath))

if '__main__' == __name__:
    main_processtemplate()
