"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const public_suffixes_1 = require("./public-suffixes");
/**
 * Returns the apex domain (domain.com) from a subdomain (www.sub.domain.com)
 */
function apexDomain(domainName) {
    const parts = domainName.split('.').reverse();
    let curr = public_suffixes_1.publicSuffixes;
    const accumulated = [];
    for (const part of parts) {
        accumulated.push(part);
        if (!(part in curr)) {
            break;
        }
        curr = curr[part];
    }
    return accumulated.reverse().join('.');
}
exports.apexDomain = apexDomain;
function isDnsValidatedCertificate(cert) {
    return cert.hasOwnProperty('domainName');
}
exports.isDnsValidatedCertificate = isDnsValidatedCertificate;
function getCertificateRegion(cert) {
    const { certificateArn, stack } = cert;
    if (isDnsValidatedCertificate(cert)) {
        const requestResource = cert.node.findChild('CertificateRequestorResource').node.defaultChild;
        // @ts-ignore
        const { _cfnProperties: properties } = requestResource;
        const { Region: region } = properties;
        if (region && !core_1.Token.isUnresolved(region)) {
            return region;
        }
    }
    {
        const { region } = core_1.Arn.parse(certificateArn);
        if (region && !core_1.Token.isUnresolved(region)) {
            return region;
        }
    }
    return core_1.Stack.of(stack).region;
}
exports.getCertificateRegion = getCertificateRegion;
//# sourceMappingURL=data:application/json;base64,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