"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticsearchAccessPolicy = void 0;
const iam = require("@aws-cdk/aws-iam");
const cr = require("@aws-cdk/custom-resources");
/**
 * Creates LogGroup resource policies.
 */
class ElasticsearchAccessPolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.accessPolicies,
        });
        super(scope, id, {
            resourceType: 'Custom::ElasticsearchAccessPolicy',
            onUpdate: {
                action: 'updateElasticsearchDomainConfig',
                service: 'ES',
                parameters: {
                    DomainName: props.domainName,
                    AccessPolicies: JSON.stringify(policyDocument.toJSON()),
                },
                // this is needed to limit the response body, otherwise it exceeds the CFN 4k limit
                outputPath: 'DomainConfig.ElasticsearchClusterConfig.AccessPolicies',
                physicalResourceId: cr.PhysicalResourceId.of(`${props.domainName}AccessPolicy`),
            },
            policy: cr.AwsCustomResourcePolicy.fromSdkCalls({ resources: [props.domainArn] }),
        });
    }
}
exports.ElasticsearchAccessPolicy = ElasticsearchAccessPolicy;
//# sourceMappingURL=data:application/json;base64,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