"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToOpenSearch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
class LambdaToOpenSearch extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToOpenSearch class.
     * @param {Construct} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToOpenSearchProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        if (props.vpcProps && !props.deployVpc) {
            throw new Error("Error - deployVpc must be true when defining vpcProps");
        }
        if (props.lambdaFunctionProps?.vpc || props.lambdaFunctionProps?.vpcSubnets) {
            throw new Error("Error - Define VPC using construct parameters not Lambda function props");
        }
        if (props.openSearchDomainProps?.vpcOptions) {
            throw new Error("Error - Define VPC using construct parameters not the OpenSearch Service props");
        }
        if (props.deployVpc || props.existingVpc) {
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
                existingVpc: props.existingVpc,
                userVpcProps: props.vpcProps,
                constructVpcProps: {
                    enableDnsHostnames: true,
                    enableDnsSupport: true,
                },
            });
        }
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc
        });
        // Find the lambda service Role ARN
        const lambdaFunctionRoleARN = this.lambdaFunction.role?.roleArn;
        let cognitoAuthorizedRole;
        [this.userPool, this.userPoolClient, this.identityPool, cognitoAuthorizedRole] =
            defaults.buildCognitoForSearchService(this, props.cognitoDomainName ?? props.openSearchDomainName);
        let securityGroupIds;
        if (this.vpc) {
            securityGroupIds = defaults.getLambdaVpcSecurityGroupIds(this.lambdaFunction);
        }
        const buildOpenSearchProps = {
            userpool: this.userPool,
            identitypool: this.identityPool,
            cognitoAuthorizedRoleARN: cognitoAuthorizedRole.roleArn,
            serviceRoleARN: lambdaFunctionRoleARN,
            vpc: this.vpc,
            openSearchDomainName: props.openSearchDomainName,
            clientDomainProps: props.openSearchDomainProps,
            securityGroupIds
        };
        [this.openSearchDomain, this.openSearchRole] = defaults.buildOpenSearch(this, buildOpenSearchProps);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            this.cloudWatchAlarms = defaults.buildOpenSearchCWAlarms(this);
        }
        const domainEndpointEnvironmentVariableName = props.domainEndpointEnvironmentVariableName || 'DOMAIN_ENDPOINT';
        this.lambdaFunction.addEnvironment(domainEndpointEnvironmentVariableName, this.openSearchDomain.attrDomainEndpoint);
    }
}
exports.LambdaToOpenSearch = LambdaToOpenSearch;
_a = JSII_RTTI_SYMBOL_1;
LambdaToOpenSearch[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-opensearch.LambdaToOpenSearch", version: "2.26.0" };
//# sourceMappingURL=data:application/json;base64,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