from avmp.utils.ip_tools import (
    get_all_network_ips,
    get_all_networks_ips
)


def test_get_all_network_ips():
    assert type(get_all_network_ips('192.168.1.1/24')) == list
    assert get_all_network_ips('192.168.1.1/28') == ['192.168.1.0', '192.168.1.1', '192.168.1.2', '192.168.1.3', '192.168.1.4', '192.168.1.5', '192.168.1.6',
                                                     '192.168.1.7', '192.168.1.8', '192.168.1.9', '192.168.1.10', '192.168.1.11', '192.168.1.12', '192.168.1.13', '192.168.1.14', '192.168.1.15']
    assert get_all_network_ips('10.0.0.1/29') == ['10.0.0.0', '10.0.0.1',
                                                  '10.0.0.2', '10.0.0.3', '10.0.0.4', '10.0.0.5', '10.0.0.6', '10.0.0.7']


def test_get_all_networks_ips():
    assert type(get_all_networks_ips(['10.0.0.1/30'])) == list
    assert get_all_networks_ips(['10.0.0.1/30', '172.16.0.1/30']) == [['10.0.0.0', '10.0.0.1/30'], ['10.0.0.1', '10.0.0.1/30'], ['10.0.0.2', '10.0.0.1/30'], [
        '10.0.0.3', '10.0.0.1/30'], ['172.16.0.0', '172.16.0.1/30'], ['172.16.0.1', '172.16.0.1/30'], ['172.16.0.2', '172.16.0.1/30'], ['172.16.0.3', '172.16.0.1/30']]
