# This file is autogenerated by `applaudgen` from `app_store_connect_api.json`.
# Do not modify this file -- YOUR CHANGES WILL BE ERASED!

from deprecated import deprecated
from pydantic import Field
from .enums import *
from .models import *
from typing import Optional, Literal
import datetime

class ApplaudRequest(ApplaudModel):
    
    def request_dict(self) -> dict:
       return self.dict(by_alias=True, exclude_none=True)

class AgeRatingDeclarationUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            alcohol_tobacco_or_drug_use_or_references: Optional[AgeRatingDeclarationLevel]
            contests: Optional[AgeRatingDeclarationLevel]
            gambling_and_contests: Optional[bool] = Field(None, deprecated=True)
            gambling: Optional[bool]
            gambling_simulated: Optional[AgeRatingDeclarationLevel]
            kids_age_band: Optional[KidsAgeBand]
            medical_or_treatment_information: Optional[AgeRatingDeclarationLevel]
            profanity_or_crude_humor: Optional[AgeRatingDeclarationLevel]
            sexual_content_graphic_and_nudity: Optional[AgeRatingDeclarationLevel]
            sexual_content_or_nudity: Optional[AgeRatingDeclarationLevel]
            seventeen_plus: Optional[bool]
            horror_or_fear_themes: Optional[AgeRatingDeclarationLevel]
            mature_or_suggestive_themes: Optional[AgeRatingDeclarationLevel]
            unrestricted_web_access: Optional[bool]
            violence_cartoon_or_fantasy: Optional[AgeRatingDeclarationLevel]
            violence_realistic_prolonged_graphic_or_sadistic: Optional[AgeRatingDeclarationLevel]
            violence_realistic: Optional[AgeRatingDeclarationLevel]

        id: str
        type: Literal["ageRatingDeclarations"] = "ageRatingDeclarations"
        attributes: Optional[Attributes]

    data: Data

class AppClipAdvancedExperienceImageCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            file_name: str
            file_size: int

        attributes: Attributes
        type: Literal["appClipAdvancedExperienceImages"] = "appClipAdvancedExperienceImages"

    data: Data

class AppClipAdvancedExperienceImageUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            source_file_checksum: Optional[str]
            uploaded: Optional[bool]

        id: str
        type: Literal["appClipAdvancedExperienceImages"] = "appClipAdvancedExperienceImages"
        attributes: Optional[Attributes]

    data: Data

class AppClipAdvancedExperienceCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppClip(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClips"] = "appClips"

                data: Data

            class HeaderImage(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClipAdvancedExperienceImages"] = "appClipAdvancedExperienceImages"

                data: Data

            class Localizations(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClipAdvancedExperienceLocalizations"] = "appClipAdvancedExperienceLocalizations"

                data: list[Data]

            app_clip: AppClip
            header_image: HeaderImage
            localizations: Localizations

        class Attributes(ApplaudModel):
            default_language: AppClipAdvancedExperienceLanguage
            is_powered_by: bool
            link: AnyUrl
            action: Optional[AppClipAction]
            place: Optional[AppClipAdvancedExperience.Attributes.Place]
            business_category: Optional[AppClipAdvancedExperienceBusinessCategory]

        relationships: Relationships
        attributes: Attributes
        type: Literal["appClipAdvancedExperiences"] = "appClipAdvancedExperiences"

    data: Data
    included: Optional[list[AppClipAdvancedExperienceLocalizationInlineCreate]]

class AppClipAdvancedExperienceUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            action: Optional[AppClipAction]
            is_powered_by: Optional[bool]
            place: Optional[AppClipAdvancedExperience.Attributes.Place]
            business_category: Optional[AppClipAdvancedExperienceBusinessCategory]
            default_language: Optional[AppClipAdvancedExperienceLanguage]
            removed: Optional[bool]

        class Relationships(ApplaudModel):
            class AppClip(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClips"] = "appClips"

                data: Optional[Data]

            class HeaderImage(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClipAdvancedExperienceImages"] = "appClipAdvancedExperienceImages"

                data: Optional[Data]

            class Localizations(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClipAdvancedExperienceLocalizations"] = "appClipAdvancedExperienceLocalizations"

                data: Optional[list[Data]]

            app_clip: Optional[AppClip]
            header_image: Optional[HeaderImage]
            localizations: Optional[Localizations]

        id: str
        type: Literal["appClipAdvancedExperiences"] = "appClipAdvancedExperiences"
        attributes: Optional[Attributes]
        relationships: Optional[Relationships]

    data: Data
    included: Optional[list[AppClipAdvancedExperienceLocalizationInlineCreate]]

class AppClipAppStoreReviewDetailCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppClipDefaultExperience(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"

                data: Data

            app_clip_default_experience: AppClipDefaultExperience

        class Attributes(ApplaudModel):
            invocation_urls: Optional[list[str]]

        relationships: Relationships
        type: Literal["appClipAppStoreReviewDetails"] = "appClipAppStoreReviewDetails"
        attributes: Optional[Attributes]

    data: Data

class AppClipAppStoreReviewDetailUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            invocation_urls: Optional[list[str]]

        id: str
        type: Literal["appClipAppStoreReviewDetails"] = "appClipAppStoreReviewDetails"
        attributes: Optional[Attributes]

    data: Data

class AppClipDefaultExperienceLocalizationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppClipDefaultExperience(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"

                data: Data

            app_clip_default_experience: AppClipDefaultExperience

        class Attributes(ApplaudModel):
            locale: str
            subtitle: Optional[str]

        relationships: Relationships
        attributes: Attributes
        type: Literal["appClipDefaultExperienceLocalizations"] = "appClipDefaultExperienceLocalizations"

    data: Data

class AppClipDefaultExperienceLocalizationUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            subtitle: Optional[str]

        id: str
        type: Literal["appClipDefaultExperienceLocalizations"] = "appClipDefaultExperienceLocalizations"
        attributes: Optional[Attributes]

    data: Data

class AppClipDefaultExperienceCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppClip(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClips"] = "appClips"

                data: Data

            class ReleaseWithAppStoreVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersions"] = "appStoreVersions"

                data: Optional[Data]

            class AppClipDefaultExperienceTemplate(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"

                data: Optional[Data]

            app_clip: AppClip
            release_with_app_store_version: Optional[ReleaseWithAppStoreVersion]
            app_clip_default_experience_template: Optional[AppClipDefaultExperienceTemplate]

        class Attributes(ApplaudModel):
            action: Optional[AppClipAction]

        relationships: Relationships
        type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"
        attributes: Optional[Attributes]

    data: Data

class AppClipDefaultExperienceUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            action: Optional[AppClipAction]

        class Relationships(ApplaudModel):
            class ReleaseWithAppStoreVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersions"] = "appStoreVersions"

                data: Optional[Data]

            release_with_app_store_version: Optional[ReleaseWithAppStoreVersion]

        id: str
        type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"
        attributes: Optional[Attributes]
        relationships: Optional[Relationships]

    data: Data

class AppClipHeaderImageCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppClipDefaultExperienceLocalization(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClipDefaultExperienceLocalizations"] = "appClipDefaultExperienceLocalizations"

                data: Data

            app_clip_default_experience_localization: AppClipDefaultExperienceLocalization

        class Attributes(ApplaudModel):
            file_name: str
            file_size: int

        relationships: Relationships
        attributes: Attributes
        type: Literal["appClipHeaderImages"] = "appClipHeaderImages"

    data: Data

class AppClipHeaderImageUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            source_file_checksum: Optional[str]
            uploaded: Optional[bool]

        id: str
        type: Literal["appClipHeaderImages"] = "appClipHeaderImages"
        attributes: Optional[Attributes]

    data: Data

class AppInfoLocalizationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppInfo(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appInfos"] = "appInfos"

                data: Data

            app_info: AppInfo

        class Attributes(ApplaudModel):
            locale: str
            name: Optional[str]
            subtitle: Optional[str]
            privacy_policy_url: Optional[str]
            privacy_choices_url: Optional[str]
            privacy_policy_text: Optional[str]

        relationships: Relationships
        attributes: Attributes
        type: Literal["appInfoLocalizations"] = "appInfoLocalizations"

    data: Data

class AppInfoLocalizationUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            name: Optional[str]
            subtitle: Optional[str]
            privacy_policy_url: Optional[str]
            privacy_choices_url: Optional[str]
            privacy_policy_text: Optional[str]

        id: str
        type: Literal["appInfoLocalizations"] = "appInfoLocalizations"
        attributes: Optional[Attributes]

    data: Data

class AppInfoUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class PrimaryCategory(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appCategories"] = "appCategories"

                data: Optional[Data]

            class PrimarySubcategoryOne(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appCategories"] = "appCategories"

                data: Optional[Data]

            class PrimarySubcategoryTwo(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appCategories"] = "appCategories"

                data: Optional[Data]

            class SecondaryCategory(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appCategories"] = "appCategories"

                data: Optional[Data]

            class SecondarySubcategoryOne(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appCategories"] = "appCategories"

                data: Optional[Data]

            class SecondarySubcategoryTwo(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appCategories"] = "appCategories"

                data: Optional[Data]

            primary_category: Optional[PrimaryCategory]
            primary_subcategory_one: Optional[PrimarySubcategoryOne]
            primary_subcategory_two: Optional[PrimarySubcategoryTwo]
            secondary_category: Optional[SecondaryCategory]
            secondary_subcategory_one: Optional[SecondarySubcategoryOne]
            secondary_subcategory_two: Optional[SecondarySubcategoryTwo]

        id: str
        type: Literal["appInfos"] = "appInfos"
        relationships: Optional[Relationships]

    data: Data

class AppPreOrderCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class App(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["apps"] = "apps"

                data: Data

            app: App

        class Attributes(ApplaudModel):
            app_release_date: Optional[datetime.date]

        relationships: Relationships
        type: Literal["appPreOrders"] = "appPreOrders"
        attributes: Optional[Attributes]

    data: Data

class AppPreOrderUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            app_release_date: Optional[datetime.date]

        id: str
        type: Literal["appPreOrders"] = "appPreOrders"
        attributes: Optional[Attributes]

    data: Data

class AppPreviewSetCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            preview_type: PreviewType

        class Relationships(ApplaudModel):
            class AppStoreVersionLocalization(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersionLocalizations"] = "appStoreVersionLocalizations"

                data: Optional[Data]

            app_store_version_localization: Optional[AppStoreVersionLocalization]

        attributes: Attributes
        type: Literal["appPreviewSets"] = "appPreviewSets"
        relationships: Optional[Relationships]

    data: Data

class AppPreviewCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppPreviewSet(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appPreviewSets"] = "appPreviewSets"

                data: Data

            app_preview_set: AppPreviewSet

        class Attributes(ApplaudModel):
            file_name: str
            file_size: int
            preview_frame_time_code: Optional[str]
            mime_type: Optional[str]

        relationships: Relationships
        attributes: Attributes
        type: Literal["appPreviews"] = "appPreviews"

    data: Data

class AppPreviewUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            source_file_checksum: Optional[str]
            preview_frame_time_code: Optional[str]
            uploaded: Optional[bool]

        id: str
        type: Literal["appPreviews"] = "appPreviews"
        attributes: Optional[Attributes]

    data: Data

class AppScreenshotSetCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            screenshot_display_type: ScreenshotDisplayType

        class Relationships(ApplaudModel):
            class AppStoreVersionLocalization(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersionLocalizations"] = "appStoreVersionLocalizations"

                data: Optional[Data]

            app_store_version_localization: Optional[AppStoreVersionLocalization]

        attributes: Attributes
        type: Literal["appScreenshotSets"] = "appScreenshotSets"
        relationships: Optional[Relationships]

    data: Data

class AppScreenshotCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppScreenshotSet(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appScreenshotSets"] = "appScreenshotSets"

                data: Data

            app_screenshot_set: AppScreenshotSet

        class Attributes(ApplaudModel):
            file_name: str
            file_size: int

        relationships: Relationships
        attributes: Attributes
        type: Literal["appScreenshots"] = "appScreenshots"

    data: Data

class AppScreenshotUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            source_file_checksum: Optional[str]
            uploaded: Optional[bool]

        id: str
        type: Literal["appScreenshots"] = "appScreenshots"
        attributes: Optional[Attributes]

    data: Data

class AppStoreReviewAttachmentCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppStoreReviewDetail(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreReviewDetails"] = "appStoreReviewDetails"

                data: Data

            app_store_review_detail: AppStoreReviewDetail

        class Attributes(ApplaudModel):
            file_name: str
            file_size: int

        relationships: Relationships
        attributes: Attributes
        type: Literal["appStoreReviewAttachments"] = "appStoreReviewAttachments"

    data: Data

class AppStoreReviewAttachmentUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            source_file_checksum: Optional[str]
            uploaded: Optional[bool]

        id: str
        type: Literal["appStoreReviewAttachments"] = "appStoreReviewAttachments"
        attributes: Optional[Attributes]

    data: Data

class AppStoreReviewDetailCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppStoreVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersions"] = "appStoreVersions"

                data: Data

            app_store_version: AppStoreVersion

        class Attributes(ApplaudModel):
            contact_first_name: Optional[str]
            contact_last_name: Optional[str]
            contact_phone: Optional[str]
            contact_email: Optional[str]
            demo_account_name: Optional[str]
            demo_account_password: Optional[str]
            demo_account_required: Optional[bool]
            notes: Optional[str]

        relationships: Relationships
        type: Literal["appStoreReviewDetails"] = "appStoreReviewDetails"
        attributes: Optional[Attributes]

    data: Data

class AppStoreReviewDetailUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            contact_first_name: Optional[str]
            contact_last_name: Optional[str]
            contact_phone: Optional[str]
            contact_email: Optional[str]
            demo_account_name: Optional[str]
            demo_account_password: Optional[str]
            demo_account_required: Optional[bool]
            notes: Optional[str]

        id: str
        type: Literal["appStoreReviewDetails"] = "appStoreReviewDetails"
        attributes: Optional[Attributes]

    data: Data

class AppStoreVersionLocalizationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppStoreVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersions"] = "appStoreVersions"

                data: Data

            app_store_version: AppStoreVersion

        class Attributes(ApplaudModel):
            locale: str
            description: Optional[str]
            keywords: Optional[str]
            marketing_url: Optional[AnyUrl]
            promotional_text: Optional[str]
            support_url: Optional[AnyUrl]
            whats_new: Optional[str]

        relationships: Relationships
        attributes: Attributes
        type: Literal["appStoreVersionLocalizations"] = "appStoreVersionLocalizations"

    data: Data

class AppStoreVersionLocalizationUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            description: Optional[str]
            keywords: Optional[str]
            marketing_url: Optional[AnyUrl]
            promotional_text: Optional[str]
            support_url: Optional[AnyUrl]
            whats_new: Optional[str]

        id: str
        type: Literal["appStoreVersionLocalizations"] = "appStoreVersionLocalizations"
        attributes: Optional[Attributes]

    data: Data

class AppStoreVersionPhasedReleaseCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppStoreVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersions"] = "appStoreVersions"

                data: Data

            app_store_version: AppStoreVersion

        class Attributes(ApplaudModel):
            phased_release_state: Optional[PhasedReleaseState]

        relationships: Relationships
        type: Literal["appStoreVersionPhasedReleases"] = "appStoreVersionPhasedReleases"
        attributes: Optional[Attributes]

    data: Data

class AppStoreVersionPhasedReleaseUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            phased_release_state: Optional[PhasedReleaseState]

        id: str
        type: Literal["appStoreVersionPhasedReleases"] = "appStoreVersionPhasedReleases"
        attributes: Optional[Attributes]

    data: Data

class AppStoreVersionReleaseRequest(ApplaudRequest):
    links: ResourceLinks
    id: str
    type: Literal["appStoreVersionReleaseRequests"] = "appStoreVersionReleaseRequests"

class AppStoreVersionReleaseRequestCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppStoreVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersions"] = "appStoreVersions"

                data: Data

            app_store_version: AppStoreVersion

        relationships: Relationships
        type: Literal["appStoreVersionReleaseRequests"] = "appStoreVersionReleaseRequests"

    data: Data

class AppStoreVersionSubmissionCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppStoreVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersions"] = "appStoreVersions"

                data: Data

            app_store_version: AppStoreVersion

        relationships: Relationships
        type: Literal["appStoreVersionSubmissions"] = "appStoreVersionSubmissions"

    data: Data

class AppStoreVersionCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class App(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["apps"] = "apps"

                data: Data

            class AppStoreVersionLocalizations(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersionLocalizations"] = "appStoreVersionLocalizations"

                data: Optional[list[Data]]

            class Build(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["builds"] = "builds"

                data: Optional[Data]

            app: App
            app_store_version_localizations: Optional[AppStoreVersionLocalizations]
            build: Optional[Build]

        class Attributes(ApplaudModel):
            version_string: str
            platform: Platform
            copyright: Optional[str]
            release_type: Optional[AppStoreVersionReleaseType]
            earliest_release_date: Optional[datetime.datetime]
            uses_idfa: Optional[bool] = Field(None, deprecated=True)

        relationships: Relationships
        attributes: Attributes
        type: Literal["appStoreVersions"] = "appStoreVersions"

    data: Data

class AppStoreVersionUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            version_string: Optional[str]
            copyright: Optional[str]
            release_type: Optional[AppStoreVersionReleaseType]
            earliest_release_date: Optional[datetime.datetime]
            uses_idfa: Optional[bool] = Field(None, deprecated=True)
            downloadable: Optional[bool]

        class Relationships(ApplaudModel):
            class Build(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["builds"] = "builds"

                data: Optional[Data]

            class AppClipDefaultExperience(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"

                data: Optional[Data]

            build: Optional[Build]
            app_clip_default_experience: Optional[AppClipDefaultExperience]

        id: str
        type: Literal["appStoreVersions"] = "appStoreVersions"
        attributes: Optional[Attributes]
        relationships: Optional[Relationships]

    data: Data

class AppUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            bundle_id: Optional[str]
            primary_locale: Optional[str]
            available_in_new_territories: Optional[bool]
            content_rights_declaration: Optional[AppContentRightsDeclaration]

        class Relationships(ApplaudModel):
            class Prices(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appPrices"] = "appPrices"

                data: Optional[list[Data]]

            class AvailableTerritories(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["territories"] = "territories"

                data: Optional[list[Data]]

            prices: Optional[Prices]
            available_territories: Optional[AvailableTerritories]

        id: str
        type: Literal["apps"] = "apps"
        attributes: Optional[Attributes]
        relationships: Optional[Relationships]

    data: Data
    included: Optional[list[AppPriceInlineCreate]]

class BetaAppClipInvocationLocalizationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class BetaAppClipInvocation(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["betaAppClipInvocations"] = "betaAppClipInvocations"

                data: Data

            beta_app_clip_invocation: BetaAppClipInvocation

        class Attributes(ApplaudModel):
            locale: str
            title: str

        relationships: Relationships
        attributes: Attributes
        type: Literal["betaAppClipInvocationLocalizations"] = "betaAppClipInvocationLocalizations"

    data: Data

class BetaAppClipInvocationLocalizationUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            title: Optional[str]

        id: str
        type: Literal["betaAppClipInvocationLocalizations"] = "betaAppClipInvocationLocalizations"
        attributes: Optional[Attributes]

    data: Data

class BetaAppClipInvocationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class BuildBundle(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["buildBundles"] = "buildBundles"

                data: Data

            class BetaAppClipInvocationLocalizations(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["betaAppClipInvocationLocalizations"] = "betaAppClipInvocationLocalizations"

                data: list[Data]

            build_bundle: BuildBundle
            beta_app_clip_invocation_localizations: BetaAppClipInvocationLocalizations

        class Attributes(ApplaudModel):
            url: AnyUrl

        relationships: Relationships
        attributes: Attributes
        type: Literal["betaAppClipInvocations"] = "betaAppClipInvocations"

    data: Data
    included: Optional[list[BetaAppClipInvocationLocalizationInlineCreate]]

class BetaAppClipInvocationUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            url: Optional[AnyUrl]

        id: str
        type: Literal["betaAppClipInvocations"] = "betaAppClipInvocations"
        attributes: Optional[Attributes]

    data: Data

class BetaAppLocalizationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class App(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["apps"] = "apps"

                data: Data

            app: App

        class Attributes(ApplaudModel):
            locale: str
            feedback_email: Optional[str]
            marketing_url: Optional[str]
            privacy_policy_url: Optional[str]
            tv_os_privacy_policy: Optional[str]
            description: Optional[str]

        relationships: Relationships
        attributes: Attributes
        type: Literal["betaAppLocalizations"] = "betaAppLocalizations"

    data: Data

class BetaAppLocalizationUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            feedback_email: Optional[str]
            marketing_url: Optional[str]
            privacy_policy_url: Optional[str]
            tv_os_privacy_policy: Optional[str]
            description: Optional[str]

        id: str
        type: Literal["betaAppLocalizations"] = "betaAppLocalizations"
        attributes: Optional[Attributes]

    data: Data

class BetaAppReviewDetailUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            contact_first_name: Optional[str]
            contact_last_name: Optional[str]
            contact_phone: Optional[str]
            contact_email: Optional[str]
            demo_account_name: Optional[str]
            demo_account_password: Optional[str]
            demo_account_required: Optional[bool]
            notes: Optional[str]

        id: str
        type: Literal["betaAppReviewDetails"] = "betaAppReviewDetails"
        attributes: Optional[Attributes]

    data: Data

class BetaAppReviewSubmissionCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class Build(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["builds"] = "builds"

                data: Data

            build: Build

        relationships: Relationships
        type: Literal["betaAppReviewSubmissions"] = "betaAppReviewSubmissions"

    data: Data

class BetaBuildLocalizationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class Build(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["builds"] = "builds"

                data: Data

            build: Build

        class Attributes(ApplaudModel):
            locale: str
            whats_new: Optional[str]

        relationships: Relationships
        attributes: Attributes
        type: Literal["betaBuildLocalizations"] = "betaBuildLocalizations"

    data: Data

class BetaBuildLocalizationUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            whats_new: Optional[str]

        id: str
        type: Literal["betaBuildLocalizations"] = "betaBuildLocalizations"
        attributes: Optional[Attributes]

    data: Data

class BetaGroupCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class App(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["apps"] = "apps"

                data: Data

            class Builds(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["builds"] = "builds"

                data: Optional[list[Data]]

            class BetaTesters(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["betaTesters"] = "betaTesters"

                data: Optional[list[Data]]

            app: App
            builds: Optional[Builds]
            beta_testers: Optional[BetaTesters]

        class Attributes(ApplaudModel):
            name: str
            is_internal_group: Optional[bool]
            has_access_to_all_builds: Optional[bool]
            public_link_enabled: Optional[bool]
            public_link_limit_enabled: Optional[bool]
            public_link_limit: Optional[int]
            feedback_enabled: Optional[bool]

        relationships: Relationships
        attributes: Attributes
        type: Literal["betaGroups"] = "betaGroups"

    data: Data

class BetaGroupUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            name: Optional[str]
            public_link_enabled: Optional[bool]
            public_link_limit_enabled: Optional[bool]
            public_link_limit: Optional[int]
            feedback_enabled: Optional[bool]
            ios_builds_available_for_apple_silicon_mac: Optional[bool]

        id: str
        type: Literal["betaGroups"] = "betaGroups"
        attributes: Optional[Attributes]

    data: Data

class BetaLicenseAgreementUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            agreement_text: Optional[str]

        id: str
        type: Literal["betaLicenseAgreements"] = "betaLicenseAgreements"
        attributes: Optional[Attributes]

    data: Data

class BetaTesterInvitationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class App(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["apps"] = "apps"

                data: Data

            class BetaTester(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["betaTesters"] = "betaTesters"

                data: Data

            app: App
            beta_tester: BetaTester

        relationships: Relationships
        type: Literal["betaTesterInvitations"] = "betaTesterInvitations"

    data: Data

class BetaTesterCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            email: EmailStr
            first_name: Optional[str]
            last_name: Optional[str]

        class Relationships(ApplaudModel):
            class BetaGroups(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["betaGroups"] = "betaGroups"

                data: Optional[list[Data]]

            class Builds(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["builds"] = "builds"

                data: Optional[list[Data]]

            beta_groups: Optional[BetaGroups]
            builds: Optional[Builds]

        attributes: Attributes
        type: Literal["betaTesters"] = "betaTesters"
        relationships: Optional[Relationships]

    data: Data

class BuildBetaDetailUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            auto_notify_enabled: Optional[bool]

        id: str
        type: Literal["buildBetaDetails"] = "buildBetaDetails"
        attributes: Optional[Attributes]

    data: Data

class BuildBetaNotificationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class Build(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["builds"] = "builds"

                data: Data

            build: Build

        relationships: Relationships
        type: Literal["buildBetaNotifications"] = "buildBetaNotifications"

    data: Data

class BuildUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            expired: Optional[bool]
            uses_non_exempt_encryption: Optional[bool]

        class Relationships(ApplaudModel):
            class AppEncryptionDeclaration(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appEncryptionDeclarations"] = "appEncryptionDeclarations"

                data: Optional[Data]

            app_encryption_declaration: Optional[AppEncryptionDeclaration]

        id: str
        type: Literal["builds"] = "builds"
        attributes: Optional[Attributes]
        relationships: Optional[Relationships]

    data: Data

class BundleIdCapabilityCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class BundleId(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["bundleIds"] = "bundleIds"

                data: Data

            bundle_id: BundleId

        class Attributes(ApplaudModel):
            capability_type: CapabilityType
            settings: Optional[list[CapabilitySetting]]

        relationships: Relationships
        attributes: Attributes
        type: Literal["bundleIdCapabilities"] = "bundleIdCapabilities"

    data: Data

class BundleIdCapabilityUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            capability_type: Optional[CapabilityType]
            settings: Optional[list[CapabilitySetting]]

        id: str
        type: Literal["bundleIdCapabilities"] = "bundleIdCapabilities"
        attributes: Optional[Attributes]

    data: Data

class BundleIdCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            identifier: str
            name: str
            platform: BundleIdPlatform
            seed_id: Optional[str]

        attributes: Attributes
        type: Literal["bundleIds"] = "bundleIds"

    data: Data

class BundleIdUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            name: Optional[str]

        id: str
        type: Literal["bundleIds"] = "bundleIds"
        attributes: Optional[Attributes]

    data: Data

class CertificateCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            csr_content: str
            certificate_type: CertificateType

        attributes: Attributes
        type: Literal["certificates"] = "certificates"

    data: Data

class CiBuildRunCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            clean: Optional[bool]

        class Relationships(ApplaudModel):
            class BuildRun(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["ciBuildRuns"] = "ciBuildRuns"

                data: Optional[Data]

            class Workflow(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["ciWorkflows"] = "ciWorkflows"

                data: Optional[Data]

            class SourceBranchOrTag(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["scmGitReferences"] = "scmGitReferences"

                data: Optional[Data]

            class PullRequest(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["scmPullRequests"] = "scmPullRequests"

                data: Optional[Data]

            build_run: Optional[BuildRun]
            workflow: Optional[Workflow]
            source_branch_or_tag: Optional[SourceBranchOrTag]
            pull_request: Optional[PullRequest]

        type: Literal["ciBuildRuns"] = "ciBuildRuns"
        attributes: Optional[Attributes]
        relationships: Optional[Relationships]

    data: Data

class CiWorkflowCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class MacOsVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["ciMacOsVersions"] = "ciMacOsVersions"

                data: Data

            class Product(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["ciProducts"] = "ciProducts"

                data: Data

            class Repository(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["scmRepositories"] = "scmRepositories"

                data: Data

            class XcodeVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["ciXcodeVersions"] = "ciXcodeVersions"

                data: Data

            mac_os_version: MacOsVersion
            product: Product
            repository: Repository
            xcode_version: XcodeVersion

        class Attributes(ApplaudModel):
            container_file_path: str
            is_enabled: bool
            name: str
            description: str
            clean: bool
            actions: list[CiAction]
            branch_start_condition: Optional[CiBranchStartCondition]
            tag_start_condition: Optional[CiTagStartCondition]
            pull_request_start_condition: Optional[CiPullRequestStartCondition]
            scheduled_start_condition: Optional[CiScheduledStartCondition]
            is_locked_for_editing: Optional[bool]

        relationships: Relationships
        attributes: Attributes
        type: Literal["ciWorkflows"] = "ciWorkflows"

    data: Data

class CiWorkflowUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            name: Optional[str]
            description: Optional[str]
            branch_start_condition: Optional[CiBranchStartCondition]
            tag_start_condition: Optional[CiTagStartCondition]
            pull_request_start_condition: Optional[CiPullRequestStartCondition]
            scheduled_start_condition: Optional[CiScheduledStartCondition]
            actions: Optional[list[CiAction]]
            is_enabled: Optional[bool]
            is_locked_for_editing: Optional[bool]
            clean: Optional[bool]
            container_file_path: Optional[str]

        class Relationships(ApplaudModel):
            class XcodeVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["ciXcodeVersions"] = "ciXcodeVersions"

                data: Optional[Data]

            class MacOsVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["ciMacOsVersions"] = "ciMacOsVersions"

                data: Optional[Data]

            xcode_version: Optional[XcodeVersion]
            mac_os_version: Optional[MacOsVersion]

        id: str
        type: Literal["ciWorkflows"] = "ciWorkflows"
        attributes: Optional[Attributes]
        relationships: Optional[Relationships]

    data: Data

class DeviceCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            name: str
            udid: str
            platform: BundleIdPlatform

        attributes: Attributes
        type: Literal["devices"] = "devices"

    data: Data

class DeviceUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            name: Optional[str]
            status: Optional[DeviceStatus]

        id: str
        type: Literal["devices"] = "devices"
        attributes: Optional[Attributes]

    data: Data

class EndUserLicenseAgreementCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class App(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["apps"] = "apps"

                data: Data

            class Territories(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["territories"] = "territories"

                data: list[Data]

            app: App
            territories: Territories

        class Attributes(ApplaudModel):
            agreement_text: str

        relationships: Relationships
        attributes: Attributes
        type: Literal["endUserLicenseAgreements"] = "endUserLicenseAgreements"

    data: Data

class EndUserLicenseAgreementUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            agreement_text: Optional[str]

        class Relationships(ApplaudModel):
            class Territories(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["territories"] = "territories"

                data: Optional[list[Data]]

            territories: Optional[Territories]

        id: str
        type: Literal["endUserLicenseAgreements"] = "endUserLicenseAgreements"
        attributes: Optional[Attributes]
        relationships: Optional[Relationships]

    data: Data

@deprecated
class IdfaDeclarationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppStoreVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersions"] = "appStoreVersions"

                data: Data

            app_store_version: AppStoreVersion

        class Attributes(ApplaudModel):
            attributes_app_installation_to_previous_ad: bool
            serves_ads: bool
            attributes_action_with_previous_ad: bool
            honors_limited_ad_tracking: bool

        relationships: Relationships
        attributes: Attributes
        type: Literal["idfaDeclarations"] = "idfaDeclarations"

    data: Data

@deprecated
class IdfaDeclarationUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            serves_ads: Optional[bool]
            attributes_app_installation_to_previous_ad: Optional[bool]
            attributes_action_with_previous_ad: Optional[bool]
            honors_limited_ad_tracking: Optional[bool]

        id: str
        type: Literal["idfaDeclarations"] = "idfaDeclarations"
        attributes: Optional[Attributes]

    data: Data

class ProfileCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class Certificates(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["certificates"] = "certificates"

                data: list[Data]

            class BundleId(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["bundleIds"] = "bundleIds"

                data: Data

            class Devices(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["devices"] = "devices"

                data: Optional[list[Data]]

            certificates: Certificates
            bundle_id: BundleId
            devices: Optional[Devices]

        class Attributes(ApplaudModel):
            profile_type: ProfileType
            name: str

        relationships: Relationships
        attributes: Attributes
        type: Literal["profiles"] = "profiles"

    data: Data

class RoutingAppCoverageCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Relationships(ApplaudModel):
            class AppStoreVersion(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["appStoreVersions"] = "appStoreVersions"

                data: Data

            app_store_version: AppStoreVersion

        class Attributes(ApplaudModel):
            file_name: str
            file_size: int

        relationships: Relationships
        attributes: Attributes
        type: Literal["routingAppCoverages"] = "routingAppCoverages"

    data: Data

class RoutingAppCoverageUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            source_file_checksum: Optional[str]
            uploaded: Optional[bool]

        id: str
        type: Literal["routingAppCoverages"] = "routingAppCoverages"
        attributes: Optional[Attributes]

    data: Data

class ScmPullRequest(ApplaudRequest):
    class Attributes(ApplaudModel):
        title: Optional[str]
        number: Optional[int]
        web_url: Optional[AnyUrl]
        source_repository_owner: Optional[str]
        source_repository_name: Optional[str]
        source_branch_name: Optional[str]
        destination_repository_owner: Optional[str]
        destination_repository_name: Optional[str]
        destination_branch_name: Optional[str]
        is_closed: Optional[bool]
        is_cross_repository: Optional[bool]

    class Relationships(ApplaudModel):
        class Repository(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["scmRepositories"] = "scmRepositories"

            links: Optional[Links]
            data: Optional[Data]

        repository: Optional[Repository]

    links: ResourceLinks
    id: str
    type: Literal["scmPullRequests"] = "scmPullRequests"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class UserInvitationCreateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            first_name: str
            last_name: str
            roles: list[UserRole]
            email: EmailStr
            all_apps_visible: Optional[bool]
            provisioning_allowed: Optional[bool]

        class Relationships(ApplaudModel):
            class VisibleApps(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["apps"] = "apps"

                data: Optional[list[Data]]

            visible_apps: Optional[VisibleApps]

        attributes: Attributes
        type: Literal["userInvitations"] = "userInvitations"
        relationships: Optional[Relationships]

    data: Data

class UserUpdateRequest(ApplaudRequest):
    class Data(ApplaudModel):
        class Attributes(ApplaudModel):
            roles: Optional[list[UserRole]]
            all_apps_visible: Optional[bool]
            provisioning_allowed: Optional[bool]

        class Relationships(ApplaudModel):
            class VisibleApps(ApplaudModel):
                class Data(ApplaudModel):
                    id: str
                    type: Literal["apps"] = "apps"

                data: Optional[list[Data]]

            visible_apps: Optional[VisibleApps]

        id: str
        type: Literal["users"] = "users"
        attributes: Optional[Attributes]
        relationships: Optional[Relationships]

    data: Data

class AppClipDefaultExperienceReleaseWithAppStoreVersionLinkageRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["appStoreVersions"] = "appStoreVersions"

    data: Data

class AppEncryptionDeclarationBuildsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["builds"] = "builds"

    data: list[Data]

class AppPreviewSetAppPreviewsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["appPreviews"] = "appPreviews"

    data: list[Data]

class AppScreenshotSetAppScreenshotsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["appScreenshots"] = "appScreenshots"

    data: list[Data]

class AppStoreVersionAppClipDefaultExperienceLinkageRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"

    data: Data

class AppStoreVersionBuildLinkageRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["builds"] = "builds"

    data: Data

class AppBetaTestersLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["betaTesters"] = "betaTesters"

    data: list[Data]

class BetaGroupBetaTestersLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["betaTesters"] = "betaTesters"

    data: list[Data]

class BetaGroupBuildsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["builds"] = "builds"

    data: list[Data]

class BetaTesterAppsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["apps"] = "apps"

    data: list[Data]

class BetaTesterBetaGroupsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["betaGroups"] = "betaGroups"

    data: list[Data]

class BetaTesterBuildsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["builds"] = "builds"

    data: list[Data]

class BuildAppEncryptionDeclarationLinkageRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["appEncryptionDeclarations"] = "appEncryptionDeclarations"

    data: Data

class BuildBetaGroupsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["betaGroups"] = "betaGroups"

    data: list[Data]

class BuildIndividualTestersLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["betaTesters"] = "betaTesters"

    data: list[Data]

class GameCenterEnabledVersionCompatibleVersionsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["gameCenterEnabledVersions"] = "gameCenterEnabledVersions"

    data: list[Data]

class UserVisibleAppsLinkagesRequest(ApplaudRequest):
    class Data(ApplaudModel):
        id: str
        type: Literal["apps"] = "apps"

    data: list[Data]

