"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributeGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ram_1 = require("aws-cdk-lib/aws-ram");
const cdk = require("aws-cdk-lib");
const common_1 = require("./common");
const validation_1 = require("./private/validation");
const aws_servicecatalogappregistry_1 = require("aws-cdk-lib/aws-servicecatalogappregistry");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ATTRIBUTE_GROUP_READ_ONLY_RAM_PERMISSION_ARN = 'arn:aws:ram::aws:permission/AWSRAMPermissionServiceCatalogAppRegistryAttributeGroupReadOnly';
const ATTRIBUTE_GROUP_ALLOW_ACCESS_RAM_PERMISSION_ARN = 'arn:aws:ram::aws:permission/AWSRAMPermissionServiceCatalogAppRegistryAttributeGroupAllowAssociation';
class AttributeGroupBase extends cdk.Resource {
    shareAttributeGroup(shareOptions) {
        const principals = common_1.getPrincipalsforSharing(shareOptions);
        const shareName = `RAMShare${common_1.hashValues(aws_cdk_lib_1.Names.nodeUniqueId(this.node), this.node.children.length.toString())}`;
        new aws_ram_1.CfnResourceShare(this, shareName, {
            name: shareName,
            allowExternalPrincipals: false,
            principals: principals,
            resourceArns: [this.attributeGroupArn],
            permissionArns: [this.getAttributeGroupSharePermissionARN(shareOptions)],
        });
    }
    /**
     * Get the correct permission ARN based on the SharePermission
     */
    getAttributeGroupSharePermissionARN(shareOptions) {
        switch (shareOptions.sharePermission) {
            case common_1.SharePermission.ALLOW_ACCESS:
                return ATTRIBUTE_GROUP_ALLOW_ACCESS_RAM_PERMISSION_ARN;
            case common_1.SharePermission.READ_ONLY:
                return ATTRIBUTE_GROUP_READ_ONLY_RAM_PERMISSION_ARN;
            default:
                return shareOptions.sharePermission ?? ATTRIBUTE_GROUP_READ_ONLY_RAM_PERMISSION_ARN;
        }
    }
}
/**
 * A Service Catalog AppRegistry Attribute Group.
 */
class AttributeGroup extends AttributeGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicecatalogappregistry_alpha_AttributeGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AttributeGroup);
            }
            throw error;
        }
        this.validateAttributeGroupProps(props);
        const attributeGroup = new aws_servicecatalogappregistry_1.CfnAttributeGroup(this, 'Resource', {
            name: props.attributeGroupName,
            description: props.description,
            attributes: props.attributes,
        });
        this.attributeGroupArn = attributeGroup.attrArn;
        this.attributeGroupId = attributeGroup.attrId;
    }
    /**
     * Imports an attribute group construct that represents an external attribute group.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attributeGroupArn the Amazon Resource Name of the existing AppRegistry attribute group
     */
    static fromAttributeGroupArn(scope, id, attributeGroupArn) {
        const arn = cdk.Stack.of(scope).splitArn(attributeGroupArn, cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME);
        const attributeGroupId = arn.resourceName;
        if (!attributeGroupId) {
            throw new Error('Missing required Attribute Group ID from Attribute Group ARN: ' + attributeGroupArn);
        }
        class Import extends AttributeGroupBase {
            constructor() {
                super(...arguments);
                this.attributeGroupArn = attributeGroupArn;
                this.attributeGroupId = attributeGroupId;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: attributeGroupArn,
        });
    }
    validateAttributeGroupProps(props) {
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group name', 1, 256, props.attributeGroupName);
        validation_1.InputValidator.validateRegex(this.node.path, 'attribute group name', /^[a-zA-Z0-9-_]+$/, props.attributeGroupName);
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group description', 0, 1024, props.description);
    }
}
exports.AttributeGroup = AttributeGroup;
_a = JSII_RTTI_SYMBOL_1;
AttributeGroup[_a] = { fqn: "@aws-cdk/aws-servicecatalogappregistry-alpha.AttributeGroup", version: "2.44.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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