"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'Can use addCors() to add a CORS configuration'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        const bucket = new lib_1.Bucket(stack, 'Bucket');
        bucket.addCorsRule({
            allowedMethods: [lib_1.HttpMethods.GET, lib_1.HttpMethods.HEAD],
            allowedOrigins: ['https://example.com'],
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            CorsConfiguration: {
                CorsRules: [{
                        AllowedMethods: ['GET', 'HEAD'],
                        AllowedOrigins: ['https://example.com'],
                    }],
            },
        }));
        test.done();
    },
    'Bucket with multiple cors configurations'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.Bucket(stack, 'Bucket', {
            cors: [
                {
                    allowedHeaders: [
                        '*',
                    ],
                    allowedMethods: [
                        lib_1.HttpMethods.GET,
                    ],
                    allowedOrigins: [
                        '*',
                    ],
                    exposedHeaders: [
                        'Date',
                    ],
                    id: 'myCORSRuleId1',
                    maxAge: 3600,
                },
                {
                    allowedHeaders: [
                        'x-amz-*',
                    ],
                    allowedMethods: [
                        lib_1.HttpMethods.DELETE,
                    ],
                    allowedOrigins: [
                        'http://www.example1.com',
                        'http://www.example2.com',
                    ],
                    exposedHeaders: [
                        'Connection',
                        'Server',
                        'Date',
                    ],
                    id: 'myCORSRuleId2',
                    maxAge: 1800,
                },
            ],
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            CorsConfiguration: {
                CorsRules: [
                    {
                        AllowedHeaders: [
                            '*',
                        ],
                        AllowedMethods: [
                            'GET',
                        ],
                        AllowedOrigins: [
                            '*',
                        ],
                        ExposedHeaders: [
                            'Date',
                        ],
                        Id: 'myCORSRuleId1',
                        MaxAge: 3600,
                    },
                    {
                        AllowedHeaders: [
                            'x-amz-*',
                        ],
                        AllowedMethods: [
                            'DELETE',
                        ],
                        AllowedOrigins: [
                            'http://www.example1.com',
                            'http://www.example2.com',
                        ],
                        ExposedHeaders: [
                            'Connection',
                            'Server',
                            'Date',
                        ],
                        Id: 'myCORSRuleId2',
                        MaxAge: 1800,
                    },
                ],
            },
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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