"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Lambda Function as the destination for a log subscription.
 *
 * @stability stable
 */
class LambdaDestination {
    /**
     * LambdaDestinationOptions.
     *
     * @stability stable
     */
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
        jsiiDeprecationWarnings._aws_cdk_aws_logs_destinations_LambdaDestinationOptions(options);
    }
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @stability stable
     */
    bind(scope, logGroup) {
        const arn = logGroup.logGroupArn;
        if (this.options.addPermissions !== false) {
            this.fn.addPermission('CanInvokeLambda', {
                principal: new iam.ServicePrincipal('logs.amazonaws.com'),
                sourceArn: arn,
                // Using SubScription Filter as scope is okay, since every Subscription Filter has only
                // one destination.
                scope,
            });
        }
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-logs-destinations.LambdaDestination", version: "1.137.0" };
//# sourceMappingURL=data:application/json;base64,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