"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Kinesis stream as the destination for a log subscription.
 *
 * @stability stable
 */
class KinesisDestination {
    /**
     * @stability stable
     */
    constructor(stream) {
        this.stream = stream;
    }
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @stability stable
     */
    bind(scope, _sourceLogGroup) {
        // Following example from https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/SubscriptionFilters.html#DestinationKinesisExample
        // Create a role to be assumed by CWL that can write to this stream and pass itself.
        const id = 'CloudWatchLogsCanPutRecords';
        const role = scope.node.tryFindChild(id) || new iam.Role(scope, id, {
            assumedBy: new iam.ServicePrincipal('logs.amazonaws.com'),
        });
        this.stream.grantWrite(role);
        role.grantPassRole(role);
        return { arn: this.stream.streamArn, role };
    }
}
exports.KinesisDestination = KinesisDestination;
_a = JSII_RTTI_SYMBOL_1;
KinesisDestination[_a] = { fqn: "@aws-cdk/aws-logs-destinations.KinesisDestination", version: "1.137.0" };
//# sourceMappingURL=data:application/json;base64,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