# arlas-tagger-api-python
(Un)Tag fields of ARLAS collections

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 12.0.3
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://www.gisaia.com/](http://www.gisaia.com/)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import arlas_tagger_api_python 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import arlas_tagger_api_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import arlas_tagger_api_python
from arlas_tagger_api_python.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = arlas_tagger_api_python.StatusApi()
collection = 'collection_example' # str | collection
id = 'id_example' # str | The id of a previously requested (un)tag operation.
pretty = false # bool | Pretty print (optional) (default to false)

try:
    # TagStatus
    api_response = api_instance.tagging_get(collection, id, pretty=pretty)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling StatusApi->tagging_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/arlas_tagger*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*StatusApi* | [**tagging_get**](docs/StatusApi.md#tagging_get) | **GET** /status/{collection}/_tag/{id} | TagStatus
*StatusApi* | [**tagging_get_list**](docs/StatusApi.md#tagging_get_list) | **GET** /status/{collection}/_taglist | TagList
*WriteApi* | [**tag_post**](docs/WriteApi.md#tag_post) | **POST** /write/{collection}/_tag | Tag
*WriteApi* | [**tag_replay**](docs/WriteApi.md#tag_replay) | **POST** /write/{collection}/_tagreplay | TagReplay
*WriteApi* | [**untag_post**](docs/WriteApi.md#untag_post) | **POST** /write/{collection}/_untag | Untag


## Documentation For Models

 - [Error](docs/Error.md)
 - [Expression](docs/Expression.md)
 - [Failure](docs/Failure.md)
 - [Filter](docs/Filter.md)
 - [Form](docs/Form.md)
 - [Page](docs/Page.md)
 - [Projection](docs/Projection.md)
 - [Propagation](docs/Propagation.md)
 - [Search](docs/Search.md)
 - [Tag](docs/Tag.md)
 - [TagRefRequest](docs/TagRefRequest.md)
 - [TagRequest](docs/TagRequest.md)
 - [UpdateResponse](docs/UpdateResponse.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

contact@gisaia.com

