# argo-workflows
Argo Workflows is an open source container-native workflow engine for orchestrating parallel jobs on Kubernetes. For more information, please see https://argoproj.github.io/argo-workflows/

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: VERSION
- Package version: 6.3.3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import argo_workflows
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import argo_workflows
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import argo_workflows
from pprint import pprint
from argo_workflows.api import archived_workflow_service_api
from argo_workflows.model.grpc_gateway_runtime_error import GrpcGatewayRuntimeError
from argo_workflows.model.io_argoproj_workflow_v1alpha1_label_keys import IoArgoprojWorkflowV1alpha1LabelKeys
from argo_workflows.model.io_argoproj_workflow_v1alpha1_label_values import IoArgoprojWorkflowV1alpha1LabelValues
from argo_workflows.model.io_argoproj_workflow_v1alpha1_workflow import IoArgoprojWorkflowV1alpha1Workflow
from argo_workflows.model.io_argoproj_workflow_v1alpha1_workflow_list import IoArgoprojWorkflowV1alpha1WorkflowList
# Defining the host is optional and defaults to http://localhost:2746
# See configuration.py for a list of all supported configuration parameters.
configuration = argo_workflows.Configuration(
    host = "http://localhost:2746"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: BearerToken
configuration.api_key['BearerToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['BearerToken'] = 'Bearer'


# Enter a context with an instance of the API client
with argo_workflows.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = archived_workflow_service_api.ArchivedWorkflowServiceApi(api_client)
    uid = "uid_example" # str | 

    try:
        api_response = api_instance.delete_archived_workflow(uid)
        pprint(api_response)
    except argo_workflows.ApiException as e:
        print("Exception when calling ArchivedWorkflowServiceApi->delete_archived_workflow: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:2746*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ArchivedWorkflowServiceApi* | [**delete_archived_workflow**](docs/ArchivedWorkflowServiceApi.md#delete_archived_workflow) | **DELETE** /api/v1/archived-workflows/{uid} | 
*ArchivedWorkflowServiceApi* | [**get_archived_workflow**](docs/ArchivedWorkflowServiceApi.md#get_archived_workflow) | **GET** /api/v1/archived-workflows/{uid} | 
*ArchivedWorkflowServiceApi* | [**list_archived_workflow_label_keys**](docs/ArchivedWorkflowServiceApi.md#list_archived_workflow_label_keys) | **GET** /api/v1/archived-workflows-label-keys | 
*ArchivedWorkflowServiceApi* | [**list_archived_workflow_label_values**](docs/ArchivedWorkflowServiceApi.md#list_archived_workflow_label_values) | **GET** /api/v1/archived-workflows-label-values | 
*ArchivedWorkflowServiceApi* | [**list_archived_workflows**](docs/ArchivedWorkflowServiceApi.md#list_archived_workflows) | **GET** /api/v1/archived-workflows | 
*ArtifactServiceApi* | [**get_input_artifact**](docs/ArtifactServiceApi.md#get_input_artifact) | **GET** /input-artifacts/{namespace}/{name}/{nodeId}/{artifactName} | Get an input artifact.
*ArtifactServiceApi* | [**get_input_artifact_by_uid**](docs/ArtifactServiceApi.md#get_input_artifact_by_uid) | **GET** /input-artifacts-by-uid/{uid}/{nodeId}/{artifactName} | Get an input artifact by UID.
*ArtifactServiceApi* | [**get_output_artifact**](docs/ArtifactServiceApi.md#get_output_artifact) | **GET** /artifacts/{namespace}/{name}/{nodeId}/{artifactName} | Get an output artifact.
*ArtifactServiceApi* | [**get_output_artifact_by_uid**](docs/ArtifactServiceApi.md#get_output_artifact_by_uid) | **GET** /artifacts-by-uid/{uid}/{nodeId}/{artifactName} | Get an output artifact by UID.
*ClusterWorkflowTemplateServiceApi* | [**create_cluster_workflow_template**](docs/ClusterWorkflowTemplateServiceApi.md#create_cluster_workflow_template) | **POST** /api/v1/cluster-workflow-templates | 
*ClusterWorkflowTemplateServiceApi* | [**delete_cluster_workflow_template**](docs/ClusterWorkflowTemplateServiceApi.md#delete_cluster_workflow_template) | **DELETE** /api/v1/cluster-workflow-templates/{name} | 
*ClusterWorkflowTemplateServiceApi* | [**get_cluster_workflow_template**](docs/ClusterWorkflowTemplateServiceApi.md#get_cluster_workflow_template) | **GET** /api/v1/cluster-workflow-templates/{name} | 
*ClusterWorkflowTemplateServiceApi* | [**lint_cluster_workflow_template**](docs/ClusterWorkflowTemplateServiceApi.md#lint_cluster_workflow_template) | **POST** /api/v1/cluster-workflow-templates/lint | 
*ClusterWorkflowTemplateServiceApi* | [**list_cluster_workflow_templates**](docs/ClusterWorkflowTemplateServiceApi.md#list_cluster_workflow_templates) | **GET** /api/v1/cluster-workflow-templates | 
*ClusterWorkflowTemplateServiceApi* | [**update_cluster_workflow_template**](docs/ClusterWorkflowTemplateServiceApi.md#update_cluster_workflow_template) | **PUT** /api/v1/cluster-workflow-templates/{name} | 
*CronWorkflowServiceApi* | [**create_cron_workflow**](docs/CronWorkflowServiceApi.md#create_cron_workflow) | **POST** /api/v1/cron-workflows/{namespace} | 
*CronWorkflowServiceApi* | [**delete_cron_workflow**](docs/CronWorkflowServiceApi.md#delete_cron_workflow) | **DELETE** /api/v1/cron-workflows/{namespace}/{name} | 
*CronWorkflowServiceApi* | [**get_cron_workflow**](docs/CronWorkflowServiceApi.md#get_cron_workflow) | **GET** /api/v1/cron-workflows/{namespace}/{name} | 
*CronWorkflowServiceApi* | [**lint_cron_workflow**](docs/CronWorkflowServiceApi.md#lint_cron_workflow) | **POST** /api/v1/cron-workflows/{namespace}/lint | 
*CronWorkflowServiceApi* | [**list_cron_workflows**](docs/CronWorkflowServiceApi.md#list_cron_workflows) | **GET** /api/v1/cron-workflows/{namespace} | 
*CronWorkflowServiceApi* | [**resume_cron_workflow**](docs/CronWorkflowServiceApi.md#resume_cron_workflow) | **PUT** /api/v1/cron-workflows/{namespace}/{name}/resume | 
*CronWorkflowServiceApi* | [**suspend_cron_workflow**](docs/CronWorkflowServiceApi.md#suspend_cron_workflow) | **PUT** /api/v1/cron-workflows/{namespace}/{name}/suspend | 
*CronWorkflowServiceApi* | [**update_cron_workflow**](docs/CronWorkflowServiceApi.md#update_cron_workflow) | **PUT** /api/v1/cron-workflows/{namespace}/{name} | 
*EventServiceApi* | [**list_workflow_event_bindings**](docs/EventServiceApi.md#list_workflow_event_bindings) | **GET** /api/v1/workflow-event-bindings/{namespace} | 
*EventServiceApi* | [**receive_event**](docs/EventServiceApi.md#receive_event) | **POST** /api/v1/events/{namespace}/{discriminator} | 
*EventSourceServiceApi* | [**create_event_source**](docs/EventSourceServiceApi.md#create_event_source) | **POST** /api/v1/event-sources/{namespace} | 
*EventSourceServiceApi* | [**delete_event_source**](docs/EventSourceServiceApi.md#delete_event_source) | **DELETE** /api/v1/event-sources/{namespace}/{name} | 
*EventSourceServiceApi* | [**event_sources_logs**](docs/EventSourceServiceApi.md#event_sources_logs) | **GET** /api/v1/stream/event-sources/{namespace}/logs | 
*EventSourceServiceApi* | [**get_event_source**](docs/EventSourceServiceApi.md#get_event_source) | **GET** /api/v1/event-sources/{namespace}/{name} | 
*EventSourceServiceApi* | [**list_event_sources**](docs/EventSourceServiceApi.md#list_event_sources) | **GET** /api/v1/event-sources/{namespace} | 
*EventSourceServiceApi* | [**update_event_source**](docs/EventSourceServiceApi.md#update_event_source) | **PUT** /api/v1/event-sources/{namespace}/{name} | 
*EventSourceServiceApi* | [**watch_event_sources**](docs/EventSourceServiceApi.md#watch_event_sources) | **GET** /api/v1/stream/event-sources/{namespace} | 
*InfoServiceApi* | [**get_info**](docs/InfoServiceApi.md#get_info) | **GET** /api/v1/info | 
*InfoServiceApi* | [**get_user_info**](docs/InfoServiceApi.md#get_user_info) | **GET** /api/v1/userinfo | 
*InfoServiceApi* | [**get_version**](docs/InfoServiceApi.md#get_version) | **GET** /api/v1/version | 
*PipelineServiceApi* | [**delete_pipeline**](docs/PipelineServiceApi.md#delete_pipeline) | **DELETE** /api/v1/pipelines/{namespace}/{name} | 
*PipelineServiceApi* | [**get_pipeline**](docs/PipelineServiceApi.md#get_pipeline) | **GET** /api/v1/pipelines/{namespace}/{name} | 
*PipelineServiceApi* | [**list_pipelines**](docs/PipelineServiceApi.md#list_pipelines) | **GET** /api/v1/pipelines/{namespace} | 
*PipelineServiceApi* | [**pipeline_logs**](docs/PipelineServiceApi.md#pipeline_logs) | **GET** /api/v1/stream/pipelines/{namespace}/logs | 
*PipelineServiceApi* | [**restart_pipeline**](docs/PipelineServiceApi.md#restart_pipeline) | **POST** /api/v1/pipelines/{namespace}/{name}/restart | 
*PipelineServiceApi* | [**watch_pipelines**](docs/PipelineServiceApi.md#watch_pipelines) | **GET** /api/v1/stream/pipelines/{namespace} | 
*PipelineServiceApi* | [**watch_steps**](docs/PipelineServiceApi.md#watch_steps) | **GET** /api/v1/stream/steps/{namespace} | 
*SensorServiceApi* | [**create_sensor**](docs/SensorServiceApi.md#create_sensor) | **POST** /api/v1/sensors/{namespace} | 
*SensorServiceApi* | [**delete_sensor**](docs/SensorServiceApi.md#delete_sensor) | **DELETE** /api/v1/sensors/{namespace}/{name} | 
*SensorServiceApi* | [**get_sensor**](docs/SensorServiceApi.md#get_sensor) | **GET** /api/v1/sensors/{namespace}/{name} | 
*SensorServiceApi* | [**list_sensors**](docs/SensorServiceApi.md#list_sensors) | **GET** /api/v1/sensors/{namespace} | 
*SensorServiceApi* | [**sensors_logs**](docs/SensorServiceApi.md#sensors_logs) | **GET** /api/v1/stream/sensors/{namespace}/logs | 
*SensorServiceApi* | [**update_sensor**](docs/SensorServiceApi.md#update_sensor) | **PUT** /api/v1/sensors/{namespace}/{name} | 
*SensorServiceApi* | [**watch_sensors**](docs/SensorServiceApi.md#watch_sensors) | **GET** /api/v1/stream/sensors/{namespace} | 
*WorkflowServiceApi* | [**create_workflow**](docs/WorkflowServiceApi.md#create_workflow) | **POST** /api/v1/workflows/{namespace} | 
*WorkflowServiceApi* | [**delete_workflow**](docs/WorkflowServiceApi.md#delete_workflow) | **DELETE** /api/v1/workflows/{namespace}/{name} | 
*WorkflowServiceApi* | [**get_workflow**](docs/WorkflowServiceApi.md#get_workflow) | **GET** /api/v1/workflows/{namespace}/{name} | 
*WorkflowServiceApi* | [**lint_workflow**](docs/WorkflowServiceApi.md#lint_workflow) | **POST** /api/v1/workflows/{namespace}/lint | 
*WorkflowServiceApi* | [**list_workflows**](docs/WorkflowServiceApi.md#list_workflows) | **GET** /api/v1/workflows/{namespace} | 
*WorkflowServiceApi* | [**pod_logs**](docs/WorkflowServiceApi.md#pod_logs) | **GET** /api/v1/workflows/{namespace}/{name}/{podName}/log | DEPRECATED: Cannot work via HTTP if podName is an empty string. Use WorkflowLogs.
*WorkflowServiceApi* | [**resubmit_workflow**](docs/WorkflowServiceApi.md#resubmit_workflow) | **PUT** /api/v1/workflows/{namespace}/{name}/resubmit | 
*WorkflowServiceApi* | [**resume_workflow**](docs/WorkflowServiceApi.md#resume_workflow) | **PUT** /api/v1/workflows/{namespace}/{name}/resume | 
*WorkflowServiceApi* | [**retry_workflow**](docs/WorkflowServiceApi.md#retry_workflow) | **PUT** /api/v1/workflows/{namespace}/{name}/retry | 
*WorkflowServiceApi* | [**set_workflow**](docs/WorkflowServiceApi.md#set_workflow) | **PUT** /api/v1/workflows/{namespace}/{name}/set | 
*WorkflowServiceApi* | [**stop_workflow**](docs/WorkflowServiceApi.md#stop_workflow) | **PUT** /api/v1/workflows/{namespace}/{name}/stop | 
*WorkflowServiceApi* | [**submit_workflow**](docs/WorkflowServiceApi.md#submit_workflow) | **POST** /api/v1/workflows/{namespace}/submit | 
*WorkflowServiceApi* | [**suspend_workflow**](docs/WorkflowServiceApi.md#suspend_workflow) | **PUT** /api/v1/workflows/{namespace}/{name}/suspend | 
*WorkflowServiceApi* | [**terminate_workflow**](docs/WorkflowServiceApi.md#terminate_workflow) | **PUT** /api/v1/workflows/{namespace}/{name}/terminate | 
*WorkflowServiceApi* | [**watch_events**](docs/WorkflowServiceApi.md#watch_events) | **GET** /api/v1/stream/events/{namespace} | 
*WorkflowServiceApi* | [**watch_workflows**](docs/WorkflowServiceApi.md#watch_workflows) | **GET** /api/v1/workflow-events/{namespace} | 
*WorkflowServiceApi* | [**workflow_logs**](docs/WorkflowServiceApi.md#workflow_logs) | **GET** /api/v1/workflows/{namespace}/{name}/log | 
*WorkflowTemplateServiceApi* | [**create_workflow_template**](docs/WorkflowTemplateServiceApi.md#create_workflow_template) | **POST** /api/v1/workflow-templates/{namespace} | 
*WorkflowTemplateServiceApi* | [**delete_workflow_template**](docs/WorkflowTemplateServiceApi.md#delete_workflow_template) | **DELETE** /api/v1/workflow-templates/{namespace}/{name} | 
*WorkflowTemplateServiceApi* | [**get_workflow_template**](docs/WorkflowTemplateServiceApi.md#get_workflow_template) | **GET** /api/v1/workflow-templates/{namespace}/{name} | 
*WorkflowTemplateServiceApi* | [**lint_workflow_template**](docs/WorkflowTemplateServiceApi.md#lint_workflow_template) | **POST** /api/v1/workflow-templates/{namespace}/lint | 
*WorkflowTemplateServiceApi* | [**list_workflow_templates**](docs/WorkflowTemplateServiceApi.md#list_workflow_templates) | **GET** /api/v1/workflow-templates/{namespace} | 
*WorkflowTemplateServiceApi* | [**update_workflow_template**](docs/WorkflowTemplateServiceApi.md#update_workflow_template) | **PUT** /api/v1/workflow-templates/{namespace}/{name} | 


## Documentation For Models

 - [AWSElasticBlockStoreVolumeSource](docs/AWSElasticBlockStoreVolumeSource.md)
 - [Affinity](docs/Affinity.md)
 - [AzureDiskVolumeSource](docs/AzureDiskVolumeSource.md)
 - [AzureFileVolumeSource](docs/AzureFileVolumeSource.md)
 - [CSIVolumeSource](docs/CSIVolumeSource.md)
 - [Capabilities](docs/Capabilities.md)
 - [CephFSVolumeSource](docs/CephFSVolumeSource.md)
 - [CinderVolumeSource](docs/CinderVolumeSource.md)
 - [Condition](docs/Condition.md)
 - [ConfigMapEnvSource](docs/ConfigMapEnvSource.md)
 - [ConfigMapKeySelector](docs/ConfigMapKeySelector.md)
 - [ConfigMapProjection](docs/ConfigMapProjection.md)
 - [ConfigMapVolumeSource](docs/ConfigMapVolumeSource.md)
 - [Container](docs/Container.md)
 - [ContainerPort](docs/ContainerPort.md)
 - [CreateOptions](docs/CreateOptions.md)
 - [DownwardAPIProjection](docs/DownwardAPIProjection.md)
 - [DownwardAPIVolumeFile](docs/DownwardAPIVolumeFile.md)
 - [DownwardAPIVolumeSource](docs/DownwardAPIVolumeSource.md)
 - [Duration](docs/Duration.md)
 - [EmptyDirVolumeSource](docs/EmptyDirVolumeSource.md)
 - [EnvFromSource](docs/EnvFromSource.md)
 - [EnvVar](docs/EnvVar.md)
 - [EnvVarSource](docs/EnvVarSource.md)
 - [EphemeralVolumeSource](docs/EphemeralVolumeSource.md)
 - [Event](docs/Event.md)
 - [EventSeries](docs/EventSeries.md)
 - [EventSource](docs/EventSource.md)
 - [EventsourceCreateEventSourceRequest](docs/EventsourceCreateEventSourceRequest.md)
 - [EventsourceEventSourceWatchEvent](docs/EventsourceEventSourceWatchEvent.md)
 - [EventsourceLogEntry](docs/EventsourceLogEntry.md)
 - [EventsourceUpdateEventSourceRequest](docs/EventsourceUpdateEventSourceRequest.md)
 - [ExecAction](docs/ExecAction.md)
 - [FCVolumeSource](docs/FCVolumeSource.md)
 - [FlexVolumeSource](docs/FlexVolumeSource.md)
 - [FlockerVolumeSource](docs/FlockerVolumeSource.md)
 - [GCEPersistentDiskVolumeSource](docs/GCEPersistentDiskVolumeSource.md)
 - [GRPCAction](docs/GRPCAction.md)
 - [GitRepoVolumeSource](docs/GitRepoVolumeSource.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1AWSCredentials](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1AWSCredentials.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1AWSEndpoint](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1AWSEndpoint.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1AbstractStep](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1AbstractStep.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1AbstractVolumeSource](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1AbstractVolumeSource.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Backoff](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Backoff.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Cat](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Cat.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Code](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Code.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Container](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Container.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Cron](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Cron.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1DBDataSource](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1DBDataSource.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1DBDataSourceFrom](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1DBDataSourceFrom.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1DBSink](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1DBSink.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1DBSource](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1DBSource.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Database](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Database.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Dedupe](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Dedupe.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Expand](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Expand.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Filter](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Filter.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Flatten](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Flatten.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Git](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Git.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Group](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Group.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1HTTPHeader](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1HTTPHeader.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1HTTPHeaderSource](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1HTTPHeaderSource.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1HTTPSink](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1HTTPSink.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1HTTPSource](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1HTTPSource.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Interface](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Interface.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1JetStream](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1JetStream.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1JetStreamSink](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1JetStreamSink.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1JetStreamSource](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1JetStreamSource.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Kafka](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Kafka.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1KafkaConfig](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1KafkaConfig.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1KafkaNET](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1KafkaNET.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1KafkaSink](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1KafkaSink.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1KafkaSource](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1KafkaSource.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Log](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Log.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Map](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Map.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Metadata](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Metadata.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1NATSAuth](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1NATSAuth.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Pipeline](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Pipeline.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1PipelineList](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1PipelineList.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1PipelineSpec](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1PipelineSpec.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1PipelineStatus](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1PipelineStatus.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1S3](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1S3.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1S3Sink](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1S3Sink.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1S3Source](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1S3Source.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1SASL](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1SASL.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1SQLAction](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1SQLAction.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1SQLStatement](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1SQLStatement.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1STAN](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1STAN.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Scale](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Scale.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Sidecar](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Sidecar.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Sink](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Sink.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Source](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Source.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Step](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Step.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1StepSpec](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1StepSpec.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1StepStatus](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1StepStatus.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1Storage](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1Storage.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1TLS](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1TLS.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1VolumeSink](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1VolumeSink.md)
 - [GithubComArgoprojLabsArgoDataflowApiV1alpha1VolumeSource](docs/GithubComArgoprojLabsArgoDataflowApiV1alpha1VolumeSource.md)
 - [GlusterfsVolumeSource](docs/GlusterfsVolumeSource.md)
 - [GoogleProtobufAny](docs/GoogleProtobufAny.md)
 - [GroupVersionResource](docs/GroupVersionResource.md)
 - [GrpcGatewayRuntimeError](docs/GrpcGatewayRuntimeError.md)
 - [GrpcGatewayRuntimeStreamError](docs/GrpcGatewayRuntimeStreamError.md)
 - [HTTPGetAction](docs/HTTPGetAction.md)
 - [HTTPHeader](docs/HTTPHeader.md)
 - [HostAlias](docs/HostAlias.md)
 - [HostPathVolumeSource](docs/HostPathVolumeSource.md)
 - [ISCSIVolumeSource](docs/ISCSIVolumeSource.md)
 - [IoArgoprojEventsV1alpha1AMQPConsumeConfig](docs/IoArgoprojEventsV1alpha1AMQPConsumeConfig.md)
 - [IoArgoprojEventsV1alpha1AMQPEventSource](docs/IoArgoprojEventsV1alpha1AMQPEventSource.md)
 - [IoArgoprojEventsV1alpha1AMQPExchangeDeclareConfig](docs/IoArgoprojEventsV1alpha1AMQPExchangeDeclareConfig.md)
 - [IoArgoprojEventsV1alpha1AMQPQueueBindConfig](docs/IoArgoprojEventsV1alpha1AMQPQueueBindConfig.md)
 - [IoArgoprojEventsV1alpha1AMQPQueueDeclareConfig](docs/IoArgoprojEventsV1alpha1AMQPQueueDeclareConfig.md)
 - [IoArgoprojEventsV1alpha1AWSLambdaTrigger](docs/IoArgoprojEventsV1alpha1AWSLambdaTrigger.md)
 - [IoArgoprojEventsV1alpha1Amount](docs/IoArgoprojEventsV1alpha1Amount.md)
 - [IoArgoprojEventsV1alpha1ArgoWorkflowTrigger](docs/IoArgoprojEventsV1alpha1ArgoWorkflowTrigger.md)
 - [IoArgoprojEventsV1alpha1ArtifactLocation](docs/IoArgoprojEventsV1alpha1ArtifactLocation.md)
 - [IoArgoprojEventsV1alpha1AzureEventHubsTrigger](docs/IoArgoprojEventsV1alpha1AzureEventHubsTrigger.md)
 - [IoArgoprojEventsV1alpha1AzureEventsHubEventSource](docs/IoArgoprojEventsV1alpha1AzureEventsHubEventSource.md)
 - [IoArgoprojEventsV1alpha1Backoff](docs/IoArgoprojEventsV1alpha1Backoff.md)
 - [IoArgoprojEventsV1alpha1BasicAuth](docs/IoArgoprojEventsV1alpha1BasicAuth.md)
 - [IoArgoprojEventsV1alpha1BitbucketAuth](docs/IoArgoprojEventsV1alpha1BitbucketAuth.md)
 - [IoArgoprojEventsV1alpha1BitbucketBasicAuth](docs/IoArgoprojEventsV1alpha1BitbucketBasicAuth.md)
 - [IoArgoprojEventsV1alpha1BitbucketEventSource](docs/IoArgoprojEventsV1alpha1BitbucketEventSource.md)
 - [IoArgoprojEventsV1alpha1BitbucketServerEventSource](docs/IoArgoprojEventsV1alpha1BitbucketServerEventSource.md)
 - [IoArgoprojEventsV1alpha1BitbucketServerRepository](docs/IoArgoprojEventsV1alpha1BitbucketServerRepository.md)
 - [IoArgoprojEventsV1alpha1CalendarEventSource](docs/IoArgoprojEventsV1alpha1CalendarEventSource.md)
 - [IoArgoprojEventsV1alpha1CatchupConfiguration](docs/IoArgoprojEventsV1alpha1CatchupConfiguration.md)
 - [IoArgoprojEventsV1alpha1Condition](docs/IoArgoprojEventsV1alpha1Condition.md)
 - [IoArgoprojEventsV1alpha1ConditionsResetByTime](docs/IoArgoprojEventsV1alpha1ConditionsResetByTime.md)
 - [IoArgoprojEventsV1alpha1ConditionsResetCriteria](docs/IoArgoprojEventsV1alpha1ConditionsResetCriteria.md)
 - [IoArgoprojEventsV1alpha1ConfigMapPersistence](docs/IoArgoprojEventsV1alpha1ConfigMapPersistence.md)
 - [IoArgoprojEventsV1alpha1CustomTrigger](docs/IoArgoprojEventsV1alpha1CustomTrigger.md)
 - [IoArgoprojEventsV1alpha1DataFilter](docs/IoArgoprojEventsV1alpha1DataFilter.md)
 - [IoArgoprojEventsV1alpha1EmitterEventSource](docs/IoArgoprojEventsV1alpha1EmitterEventSource.md)
 - [IoArgoprojEventsV1alpha1EventContext](docs/IoArgoprojEventsV1alpha1EventContext.md)
 - [IoArgoprojEventsV1alpha1EventDependency](docs/IoArgoprojEventsV1alpha1EventDependency.md)
 - [IoArgoprojEventsV1alpha1EventDependencyFilter](docs/IoArgoprojEventsV1alpha1EventDependencyFilter.md)
 - [IoArgoprojEventsV1alpha1EventDependencyTransformer](docs/IoArgoprojEventsV1alpha1EventDependencyTransformer.md)
 - [IoArgoprojEventsV1alpha1EventPersistence](docs/IoArgoprojEventsV1alpha1EventPersistence.md)
 - [IoArgoprojEventsV1alpha1EventSource](docs/IoArgoprojEventsV1alpha1EventSource.md)
 - [IoArgoprojEventsV1alpha1EventSourceFilter](docs/IoArgoprojEventsV1alpha1EventSourceFilter.md)
 - [IoArgoprojEventsV1alpha1EventSourceList](docs/IoArgoprojEventsV1alpha1EventSourceList.md)
 - [IoArgoprojEventsV1alpha1EventSourceSpec](docs/IoArgoprojEventsV1alpha1EventSourceSpec.md)
 - [IoArgoprojEventsV1alpha1EventSourceStatus](docs/IoArgoprojEventsV1alpha1EventSourceStatus.md)
 - [IoArgoprojEventsV1alpha1ExprFilter](docs/IoArgoprojEventsV1alpha1ExprFilter.md)
 - [IoArgoprojEventsV1alpha1FileArtifact](docs/IoArgoprojEventsV1alpha1FileArtifact.md)
 - [IoArgoprojEventsV1alpha1FileEventSource](docs/IoArgoprojEventsV1alpha1FileEventSource.md)
 - [IoArgoprojEventsV1alpha1GenericEventSource](docs/IoArgoprojEventsV1alpha1GenericEventSource.md)
 - [IoArgoprojEventsV1alpha1GitArtifact](docs/IoArgoprojEventsV1alpha1GitArtifact.md)
 - [IoArgoprojEventsV1alpha1GitCreds](docs/IoArgoprojEventsV1alpha1GitCreds.md)
 - [IoArgoprojEventsV1alpha1GitRemoteConfig](docs/IoArgoprojEventsV1alpha1GitRemoteConfig.md)
 - [IoArgoprojEventsV1alpha1GithubAppCreds](docs/IoArgoprojEventsV1alpha1GithubAppCreds.md)
 - [IoArgoprojEventsV1alpha1GithubEventSource](docs/IoArgoprojEventsV1alpha1GithubEventSource.md)
 - [IoArgoprojEventsV1alpha1GitlabEventSource](docs/IoArgoprojEventsV1alpha1GitlabEventSource.md)
 - [IoArgoprojEventsV1alpha1HDFSEventSource](docs/IoArgoprojEventsV1alpha1HDFSEventSource.md)
 - [IoArgoprojEventsV1alpha1HTTPTrigger](docs/IoArgoprojEventsV1alpha1HTTPTrigger.md)
 - [IoArgoprojEventsV1alpha1Int64OrString](docs/IoArgoprojEventsV1alpha1Int64OrString.md)
 - [IoArgoprojEventsV1alpha1K8SResourcePolicy](docs/IoArgoprojEventsV1alpha1K8SResourcePolicy.md)
 - [IoArgoprojEventsV1alpha1KafkaConsumerGroup](docs/IoArgoprojEventsV1alpha1KafkaConsumerGroup.md)
 - [IoArgoprojEventsV1alpha1KafkaEventSource](docs/IoArgoprojEventsV1alpha1KafkaEventSource.md)
 - [IoArgoprojEventsV1alpha1KafkaTrigger](docs/IoArgoprojEventsV1alpha1KafkaTrigger.md)
 - [IoArgoprojEventsV1alpha1LogTrigger](docs/IoArgoprojEventsV1alpha1LogTrigger.md)
 - [IoArgoprojEventsV1alpha1MQTTEventSource](docs/IoArgoprojEventsV1alpha1MQTTEventSource.md)
 - [IoArgoprojEventsV1alpha1Metadata](docs/IoArgoprojEventsV1alpha1Metadata.md)
 - [IoArgoprojEventsV1alpha1NATSAuth](docs/IoArgoprojEventsV1alpha1NATSAuth.md)
 - [IoArgoprojEventsV1alpha1NATSEventsSource](docs/IoArgoprojEventsV1alpha1NATSEventsSource.md)
 - [IoArgoprojEventsV1alpha1NATSTrigger](docs/IoArgoprojEventsV1alpha1NATSTrigger.md)
 - [IoArgoprojEventsV1alpha1NSQEventSource](docs/IoArgoprojEventsV1alpha1NSQEventSource.md)
 - [IoArgoprojEventsV1alpha1OpenWhiskTrigger](docs/IoArgoprojEventsV1alpha1OpenWhiskTrigger.md)
 - [IoArgoprojEventsV1alpha1OwnedRepositories](docs/IoArgoprojEventsV1alpha1OwnedRepositories.md)
 - [IoArgoprojEventsV1alpha1PayloadField](docs/IoArgoprojEventsV1alpha1PayloadField.md)
 - [IoArgoprojEventsV1alpha1PubSubEventSource](docs/IoArgoprojEventsV1alpha1PubSubEventSource.md)
 - [IoArgoprojEventsV1alpha1PulsarEventSource](docs/IoArgoprojEventsV1alpha1PulsarEventSource.md)
 - [IoArgoprojEventsV1alpha1PulsarTrigger](docs/IoArgoprojEventsV1alpha1PulsarTrigger.md)
 - [IoArgoprojEventsV1alpha1RateLimit](docs/IoArgoprojEventsV1alpha1RateLimit.md)
 - [IoArgoprojEventsV1alpha1RedisEventSource](docs/IoArgoprojEventsV1alpha1RedisEventSource.md)
 - [IoArgoprojEventsV1alpha1Resource](docs/IoArgoprojEventsV1alpha1Resource.md)
 - [IoArgoprojEventsV1alpha1ResourceEventSource](docs/IoArgoprojEventsV1alpha1ResourceEventSource.md)
 - [IoArgoprojEventsV1alpha1ResourceFilter](docs/IoArgoprojEventsV1alpha1ResourceFilter.md)
 - [IoArgoprojEventsV1alpha1S3Artifact](docs/IoArgoprojEventsV1alpha1S3Artifact.md)
 - [IoArgoprojEventsV1alpha1S3Bucket](docs/IoArgoprojEventsV1alpha1S3Bucket.md)
 - [IoArgoprojEventsV1alpha1S3Filter](docs/IoArgoprojEventsV1alpha1S3Filter.md)
 - [IoArgoprojEventsV1alpha1SASLConfig](docs/IoArgoprojEventsV1alpha1SASLConfig.md)
 - [IoArgoprojEventsV1alpha1SNSEventSource](docs/IoArgoprojEventsV1alpha1SNSEventSource.md)
 - [IoArgoprojEventsV1alpha1SQSEventSource](docs/IoArgoprojEventsV1alpha1SQSEventSource.md)
 - [IoArgoprojEventsV1alpha1SecureHeader](docs/IoArgoprojEventsV1alpha1SecureHeader.md)
 - [IoArgoprojEventsV1alpha1Selector](docs/IoArgoprojEventsV1alpha1Selector.md)
 - [IoArgoprojEventsV1alpha1Sensor](docs/IoArgoprojEventsV1alpha1Sensor.md)
 - [IoArgoprojEventsV1alpha1SensorList](docs/IoArgoprojEventsV1alpha1SensorList.md)
 - [IoArgoprojEventsV1alpha1SensorSpec](docs/IoArgoprojEventsV1alpha1SensorSpec.md)
 - [IoArgoprojEventsV1alpha1SensorStatus](docs/IoArgoprojEventsV1alpha1SensorStatus.md)
 - [IoArgoprojEventsV1alpha1Service](docs/IoArgoprojEventsV1alpha1Service.md)
 - [IoArgoprojEventsV1alpha1SlackEventSource](docs/IoArgoprojEventsV1alpha1SlackEventSource.md)
 - [IoArgoprojEventsV1alpha1SlackTrigger](docs/IoArgoprojEventsV1alpha1SlackTrigger.md)
 - [IoArgoprojEventsV1alpha1StandardK8STrigger](docs/IoArgoprojEventsV1alpha1StandardK8STrigger.md)
 - [IoArgoprojEventsV1alpha1Status](docs/IoArgoprojEventsV1alpha1Status.md)
 - [IoArgoprojEventsV1alpha1StatusPolicy](docs/IoArgoprojEventsV1alpha1StatusPolicy.md)
 - [IoArgoprojEventsV1alpha1StorageGridEventSource](docs/IoArgoprojEventsV1alpha1StorageGridEventSource.md)
 - [IoArgoprojEventsV1alpha1StorageGridFilter](docs/IoArgoprojEventsV1alpha1StorageGridFilter.md)
 - [IoArgoprojEventsV1alpha1StripeEventSource](docs/IoArgoprojEventsV1alpha1StripeEventSource.md)
 - [IoArgoprojEventsV1alpha1TLSConfig](docs/IoArgoprojEventsV1alpha1TLSConfig.md)
 - [IoArgoprojEventsV1alpha1Template](docs/IoArgoprojEventsV1alpha1Template.md)
 - [IoArgoprojEventsV1alpha1TimeFilter](docs/IoArgoprojEventsV1alpha1TimeFilter.md)
 - [IoArgoprojEventsV1alpha1Trigger](docs/IoArgoprojEventsV1alpha1Trigger.md)
 - [IoArgoprojEventsV1alpha1TriggerParameter](docs/IoArgoprojEventsV1alpha1TriggerParameter.md)
 - [IoArgoprojEventsV1alpha1TriggerParameterSource](docs/IoArgoprojEventsV1alpha1TriggerParameterSource.md)
 - [IoArgoprojEventsV1alpha1TriggerPolicy](docs/IoArgoprojEventsV1alpha1TriggerPolicy.md)
 - [IoArgoprojEventsV1alpha1TriggerTemplate](docs/IoArgoprojEventsV1alpha1TriggerTemplate.md)
 - [IoArgoprojEventsV1alpha1URLArtifact](docs/IoArgoprojEventsV1alpha1URLArtifact.md)
 - [IoArgoprojEventsV1alpha1ValueFromSource](docs/IoArgoprojEventsV1alpha1ValueFromSource.md)
 - [IoArgoprojEventsV1alpha1WatchPathConfig](docs/IoArgoprojEventsV1alpha1WatchPathConfig.md)
 - [IoArgoprojEventsV1alpha1WebhookContext](docs/IoArgoprojEventsV1alpha1WebhookContext.md)
 - [IoArgoprojWorkflowV1alpha1ArchiveStrategy](docs/IoArgoprojWorkflowV1alpha1ArchiveStrategy.md)
 - [IoArgoprojWorkflowV1alpha1Arguments](docs/IoArgoprojWorkflowV1alpha1Arguments.md)
 - [IoArgoprojWorkflowV1alpha1Artifact](docs/IoArgoprojWorkflowV1alpha1Artifact.md)
 - [IoArgoprojWorkflowV1alpha1ArtifactLocation](docs/IoArgoprojWorkflowV1alpha1ArtifactLocation.md)
 - [IoArgoprojWorkflowV1alpha1ArtifactPaths](docs/IoArgoprojWorkflowV1alpha1ArtifactPaths.md)
 - [IoArgoprojWorkflowV1alpha1ArtifactRepository](docs/IoArgoprojWorkflowV1alpha1ArtifactRepository.md)
 - [IoArgoprojWorkflowV1alpha1ArtifactRepositoryRef](docs/IoArgoprojWorkflowV1alpha1ArtifactRepositoryRef.md)
 - [IoArgoprojWorkflowV1alpha1ArtifactRepositoryRefStatus](docs/IoArgoprojWorkflowV1alpha1ArtifactRepositoryRefStatus.md)
 - [IoArgoprojWorkflowV1alpha1ArtifactoryArtifact](docs/IoArgoprojWorkflowV1alpha1ArtifactoryArtifact.md)
 - [IoArgoprojWorkflowV1alpha1ArtifactoryArtifactRepository](docs/IoArgoprojWorkflowV1alpha1ArtifactoryArtifactRepository.md)
 - [IoArgoprojWorkflowV1alpha1Backoff](docs/IoArgoprojWorkflowV1alpha1Backoff.md)
 - [IoArgoprojWorkflowV1alpha1Cache](docs/IoArgoprojWorkflowV1alpha1Cache.md)
 - [IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplate](docs/IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplate.md)
 - [IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplateCreateRequest](docs/IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplateCreateRequest.md)
 - [IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplateLintRequest](docs/IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplateLintRequest.md)
 - [IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplateList](docs/IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplateList.md)
 - [IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplateUpdateRequest](docs/IoArgoprojWorkflowV1alpha1ClusterWorkflowTemplateUpdateRequest.md)
 - [IoArgoprojWorkflowV1alpha1Condition](docs/IoArgoprojWorkflowV1alpha1Condition.md)
 - [IoArgoprojWorkflowV1alpha1ContainerNode](docs/IoArgoprojWorkflowV1alpha1ContainerNode.md)
 - [IoArgoprojWorkflowV1alpha1ContainerSetRetryStrategy](docs/IoArgoprojWorkflowV1alpha1ContainerSetRetryStrategy.md)
 - [IoArgoprojWorkflowV1alpha1ContainerSetTemplate](docs/IoArgoprojWorkflowV1alpha1ContainerSetTemplate.md)
 - [IoArgoprojWorkflowV1alpha1ContinueOn](docs/IoArgoprojWorkflowV1alpha1ContinueOn.md)
 - [IoArgoprojWorkflowV1alpha1Counter](docs/IoArgoprojWorkflowV1alpha1Counter.md)
 - [IoArgoprojWorkflowV1alpha1CreateCronWorkflowRequest](docs/IoArgoprojWorkflowV1alpha1CreateCronWorkflowRequest.md)
 - [IoArgoprojWorkflowV1alpha1CreateS3BucketOptions](docs/IoArgoprojWorkflowV1alpha1CreateS3BucketOptions.md)
 - [IoArgoprojWorkflowV1alpha1CronWorkflow](docs/IoArgoprojWorkflowV1alpha1CronWorkflow.md)
 - [IoArgoprojWorkflowV1alpha1CronWorkflowList](docs/IoArgoprojWorkflowV1alpha1CronWorkflowList.md)
 - [IoArgoprojWorkflowV1alpha1CronWorkflowResumeRequest](docs/IoArgoprojWorkflowV1alpha1CronWorkflowResumeRequest.md)
 - [IoArgoprojWorkflowV1alpha1CronWorkflowSpec](docs/IoArgoprojWorkflowV1alpha1CronWorkflowSpec.md)
 - [IoArgoprojWorkflowV1alpha1CronWorkflowStatus](docs/IoArgoprojWorkflowV1alpha1CronWorkflowStatus.md)
 - [IoArgoprojWorkflowV1alpha1CronWorkflowSuspendRequest](docs/IoArgoprojWorkflowV1alpha1CronWorkflowSuspendRequest.md)
 - [IoArgoprojWorkflowV1alpha1DAGTask](docs/IoArgoprojWorkflowV1alpha1DAGTask.md)
 - [IoArgoprojWorkflowV1alpha1DAGTemplate](docs/IoArgoprojWorkflowV1alpha1DAGTemplate.md)
 - [IoArgoprojWorkflowV1alpha1Data](docs/IoArgoprojWorkflowV1alpha1Data.md)
 - [IoArgoprojWorkflowV1alpha1DataSource](docs/IoArgoprojWorkflowV1alpha1DataSource.md)
 - [IoArgoprojWorkflowV1alpha1Event](docs/IoArgoprojWorkflowV1alpha1Event.md)
 - [IoArgoprojWorkflowV1alpha1ExecutorConfig](docs/IoArgoprojWorkflowV1alpha1ExecutorConfig.md)
 - [IoArgoprojWorkflowV1alpha1GCSArtifact](docs/IoArgoprojWorkflowV1alpha1GCSArtifact.md)
 - [IoArgoprojWorkflowV1alpha1GCSArtifactRepository](docs/IoArgoprojWorkflowV1alpha1GCSArtifactRepository.md)
 - [IoArgoprojWorkflowV1alpha1Gauge](docs/IoArgoprojWorkflowV1alpha1Gauge.md)
 - [IoArgoprojWorkflowV1alpha1GetUserInfoResponse](docs/IoArgoprojWorkflowV1alpha1GetUserInfoResponse.md)
 - [IoArgoprojWorkflowV1alpha1GitArtifact](docs/IoArgoprojWorkflowV1alpha1GitArtifact.md)
 - [IoArgoprojWorkflowV1alpha1HDFSArtifact](docs/IoArgoprojWorkflowV1alpha1HDFSArtifact.md)
 - [IoArgoprojWorkflowV1alpha1HDFSArtifactRepository](docs/IoArgoprojWorkflowV1alpha1HDFSArtifactRepository.md)
 - [IoArgoprojWorkflowV1alpha1HTTP](docs/IoArgoprojWorkflowV1alpha1HTTP.md)
 - [IoArgoprojWorkflowV1alpha1HTTPArtifact](docs/IoArgoprojWorkflowV1alpha1HTTPArtifact.md)
 - [IoArgoprojWorkflowV1alpha1HTTPHeader](docs/IoArgoprojWorkflowV1alpha1HTTPHeader.md)
 - [IoArgoprojWorkflowV1alpha1HTTPHeaderSource](docs/IoArgoprojWorkflowV1alpha1HTTPHeaderSource.md)
 - [IoArgoprojWorkflowV1alpha1Header](docs/IoArgoprojWorkflowV1alpha1Header.md)
 - [IoArgoprojWorkflowV1alpha1Histogram](docs/IoArgoprojWorkflowV1alpha1Histogram.md)
 - [IoArgoprojWorkflowV1alpha1InfoResponse](docs/IoArgoprojWorkflowV1alpha1InfoResponse.md)
 - [IoArgoprojWorkflowV1alpha1Inputs](docs/IoArgoprojWorkflowV1alpha1Inputs.md)
 - [IoArgoprojWorkflowV1alpha1LabelKeys](docs/IoArgoprojWorkflowV1alpha1LabelKeys.md)
 - [IoArgoprojWorkflowV1alpha1LabelValueFrom](docs/IoArgoprojWorkflowV1alpha1LabelValueFrom.md)
 - [IoArgoprojWorkflowV1alpha1LabelValues](docs/IoArgoprojWorkflowV1alpha1LabelValues.md)
 - [IoArgoprojWorkflowV1alpha1LifecycleHook](docs/IoArgoprojWorkflowV1alpha1LifecycleHook.md)
 - [IoArgoprojWorkflowV1alpha1Link](docs/IoArgoprojWorkflowV1alpha1Link.md)
 - [IoArgoprojWorkflowV1alpha1LintCronWorkflowRequest](docs/IoArgoprojWorkflowV1alpha1LintCronWorkflowRequest.md)
 - [IoArgoprojWorkflowV1alpha1LogEntry](docs/IoArgoprojWorkflowV1alpha1LogEntry.md)
 - [IoArgoprojWorkflowV1alpha1MemoizationStatus](docs/IoArgoprojWorkflowV1alpha1MemoizationStatus.md)
 - [IoArgoprojWorkflowV1alpha1Memoize](docs/IoArgoprojWorkflowV1alpha1Memoize.md)
 - [IoArgoprojWorkflowV1alpha1Metadata](docs/IoArgoprojWorkflowV1alpha1Metadata.md)
 - [IoArgoprojWorkflowV1alpha1MetricLabel](docs/IoArgoprojWorkflowV1alpha1MetricLabel.md)
 - [IoArgoprojWorkflowV1alpha1Metrics](docs/IoArgoprojWorkflowV1alpha1Metrics.md)
 - [IoArgoprojWorkflowV1alpha1Mutex](docs/IoArgoprojWorkflowV1alpha1Mutex.md)
 - [IoArgoprojWorkflowV1alpha1MutexHolding](docs/IoArgoprojWorkflowV1alpha1MutexHolding.md)
 - [IoArgoprojWorkflowV1alpha1MutexStatus](docs/IoArgoprojWorkflowV1alpha1MutexStatus.md)
 - [IoArgoprojWorkflowV1alpha1NodeResult](docs/IoArgoprojWorkflowV1alpha1NodeResult.md)
 - [IoArgoprojWorkflowV1alpha1NodeStatus](docs/IoArgoprojWorkflowV1alpha1NodeStatus.md)
 - [IoArgoprojWorkflowV1alpha1NodeSynchronizationStatus](docs/IoArgoprojWorkflowV1alpha1NodeSynchronizationStatus.md)
 - [IoArgoprojWorkflowV1alpha1OSSArtifact](docs/IoArgoprojWorkflowV1alpha1OSSArtifact.md)
 - [IoArgoprojWorkflowV1alpha1OSSArtifactRepository](docs/IoArgoprojWorkflowV1alpha1OSSArtifactRepository.md)
 - [IoArgoprojWorkflowV1alpha1OSSLifecycleRule](docs/IoArgoprojWorkflowV1alpha1OSSLifecycleRule.md)
 - [IoArgoprojWorkflowV1alpha1Outputs](docs/IoArgoprojWorkflowV1alpha1Outputs.md)
 - [IoArgoprojWorkflowV1alpha1ParallelSteps](docs/IoArgoprojWorkflowV1alpha1ParallelSteps.md)
 - [IoArgoprojWorkflowV1alpha1Parameter](docs/IoArgoprojWorkflowV1alpha1Parameter.md)
 - [IoArgoprojWorkflowV1alpha1PodGC](docs/IoArgoprojWorkflowV1alpha1PodGC.md)
 - [IoArgoprojWorkflowV1alpha1Prometheus](docs/IoArgoprojWorkflowV1alpha1Prometheus.md)
 - [IoArgoprojWorkflowV1alpha1RawArtifact](docs/IoArgoprojWorkflowV1alpha1RawArtifact.md)
 - [IoArgoprojWorkflowV1alpha1ResourceTemplate](docs/IoArgoprojWorkflowV1alpha1ResourceTemplate.md)
 - [IoArgoprojWorkflowV1alpha1RetryAffinity](docs/IoArgoprojWorkflowV1alpha1RetryAffinity.md)
 - [IoArgoprojWorkflowV1alpha1RetryStrategy](docs/IoArgoprojWorkflowV1alpha1RetryStrategy.md)
 - [IoArgoprojWorkflowV1alpha1S3Artifact](docs/IoArgoprojWorkflowV1alpha1S3Artifact.md)
 - [IoArgoprojWorkflowV1alpha1S3ArtifactRepository](docs/IoArgoprojWorkflowV1alpha1S3ArtifactRepository.md)
 - [IoArgoprojWorkflowV1alpha1S3EncryptionOptions](docs/IoArgoprojWorkflowV1alpha1S3EncryptionOptions.md)
 - [IoArgoprojWorkflowV1alpha1ScriptTemplate](docs/IoArgoprojWorkflowV1alpha1ScriptTemplate.md)
 - [IoArgoprojWorkflowV1alpha1SemaphoreHolding](docs/IoArgoprojWorkflowV1alpha1SemaphoreHolding.md)
 - [IoArgoprojWorkflowV1alpha1SemaphoreRef](docs/IoArgoprojWorkflowV1alpha1SemaphoreRef.md)
 - [IoArgoprojWorkflowV1alpha1SemaphoreStatus](docs/IoArgoprojWorkflowV1alpha1SemaphoreStatus.md)
 - [IoArgoprojWorkflowV1alpha1Sequence](docs/IoArgoprojWorkflowV1alpha1Sequence.md)
 - [IoArgoprojWorkflowV1alpha1Submit](docs/IoArgoprojWorkflowV1alpha1Submit.md)
 - [IoArgoprojWorkflowV1alpha1SubmitOpts](docs/IoArgoprojWorkflowV1alpha1SubmitOpts.md)
 - [IoArgoprojWorkflowV1alpha1SuspendTemplate](docs/IoArgoprojWorkflowV1alpha1SuspendTemplate.md)
 - [IoArgoprojWorkflowV1alpha1Synchronization](docs/IoArgoprojWorkflowV1alpha1Synchronization.md)
 - [IoArgoprojWorkflowV1alpha1SynchronizationStatus](docs/IoArgoprojWorkflowV1alpha1SynchronizationStatus.md)
 - [IoArgoprojWorkflowV1alpha1TTLStrategy](docs/IoArgoprojWorkflowV1alpha1TTLStrategy.md)
 - [IoArgoprojWorkflowV1alpha1TarStrategy](docs/IoArgoprojWorkflowV1alpha1TarStrategy.md)
 - [IoArgoprojWorkflowV1alpha1Template](docs/IoArgoprojWorkflowV1alpha1Template.md)
 - [IoArgoprojWorkflowV1alpha1TemplateRef](docs/IoArgoprojWorkflowV1alpha1TemplateRef.md)
 - [IoArgoprojWorkflowV1alpha1TransformationStep](docs/IoArgoprojWorkflowV1alpha1TransformationStep.md)
 - [IoArgoprojWorkflowV1alpha1UpdateCronWorkflowRequest](docs/IoArgoprojWorkflowV1alpha1UpdateCronWorkflowRequest.md)
 - [IoArgoprojWorkflowV1alpha1UserContainer](docs/IoArgoprojWorkflowV1alpha1UserContainer.md)
 - [IoArgoprojWorkflowV1alpha1ValueFrom](docs/IoArgoprojWorkflowV1alpha1ValueFrom.md)
 - [IoArgoprojWorkflowV1alpha1Version](docs/IoArgoprojWorkflowV1alpha1Version.md)
 - [IoArgoprojWorkflowV1alpha1VolumeClaimGC](docs/IoArgoprojWorkflowV1alpha1VolumeClaimGC.md)
 - [IoArgoprojWorkflowV1alpha1Workflow](docs/IoArgoprojWorkflowV1alpha1Workflow.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowCreateRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowCreateRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowEventBinding](docs/IoArgoprojWorkflowV1alpha1WorkflowEventBinding.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowEventBindingList](docs/IoArgoprojWorkflowV1alpha1WorkflowEventBindingList.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowEventBindingSpec](docs/IoArgoprojWorkflowV1alpha1WorkflowEventBindingSpec.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowLintRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowLintRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowList](docs/IoArgoprojWorkflowV1alpha1WorkflowList.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowMetadata](docs/IoArgoprojWorkflowV1alpha1WorkflowMetadata.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowResubmitRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowResubmitRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowResumeRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowResumeRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowRetryRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowRetryRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowSetRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowSetRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowSpec](docs/IoArgoprojWorkflowV1alpha1WorkflowSpec.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowStatus](docs/IoArgoprojWorkflowV1alpha1WorkflowStatus.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowStep](docs/IoArgoprojWorkflowV1alpha1WorkflowStep.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowStopRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowStopRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowSubmitRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowSubmitRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowSuspendRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowSuspendRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowTaskSetSpec](docs/IoArgoprojWorkflowV1alpha1WorkflowTaskSetSpec.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowTaskSetStatus](docs/IoArgoprojWorkflowV1alpha1WorkflowTaskSetStatus.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowTemplate](docs/IoArgoprojWorkflowV1alpha1WorkflowTemplate.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowTemplateCreateRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowTemplateCreateRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowTemplateLintRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowTemplateLintRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowTemplateList](docs/IoArgoprojWorkflowV1alpha1WorkflowTemplateList.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowTemplateRef](docs/IoArgoprojWorkflowV1alpha1WorkflowTemplateRef.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowTemplateUpdateRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowTemplateUpdateRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowTerminateRequest](docs/IoArgoprojWorkflowV1alpha1WorkflowTerminateRequest.md)
 - [IoArgoprojWorkflowV1alpha1WorkflowWatchEvent](docs/IoArgoprojWorkflowV1alpha1WorkflowWatchEvent.md)
 - [IoK8sApiPolicyV1beta1PodDisruptionBudgetSpec](docs/IoK8sApiPolicyV1beta1PodDisruptionBudgetSpec.md)
 - [KeyToPath](docs/KeyToPath.md)
 - [LabelSelector](docs/LabelSelector.md)
 - [LabelSelectorRequirement](docs/LabelSelectorRequirement.md)
 - [Lifecycle](docs/Lifecycle.md)
 - [LifecycleHandler](docs/LifecycleHandler.md)
 - [ListMeta](docs/ListMeta.md)
 - [LocalObjectReference](docs/LocalObjectReference.md)
 - [ManagedFieldsEntry](docs/ManagedFieldsEntry.md)
 - [NFSVolumeSource](docs/NFSVolumeSource.md)
 - [NodeAffinity](docs/NodeAffinity.md)
 - [NodeSelector](docs/NodeSelector.md)
 - [NodeSelectorRequirement](docs/NodeSelectorRequirement.md)
 - [NodeSelectorTerm](docs/NodeSelectorTerm.md)
 - [ObjectFieldSelector](docs/ObjectFieldSelector.md)
 - [ObjectMeta](docs/ObjectMeta.md)
 - [ObjectReference](docs/ObjectReference.md)
 - [OwnerReference](docs/OwnerReference.md)
 - [PersistentVolumeClaim](docs/PersistentVolumeClaim.md)
 - [PersistentVolumeClaimCondition](docs/PersistentVolumeClaimCondition.md)
 - [PersistentVolumeClaimSpec](docs/PersistentVolumeClaimSpec.md)
 - [PersistentVolumeClaimStatus](docs/PersistentVolumeClaimStatus.md)
 - [PersistentVolumeClaimTemplate](docs/PersistentVolumeClaimTemplate.md)
 - [PersistentVolumeClaimVolumeSource](docs/PersistentVolumeClaimVolumeSource.md)
 - [PhotonPersistentDiskVolumeSource](docs/PhotonPersistentDiskVolumeSource.md)
 - [PipelineLogEntry](docs/PipelineLogEntry.md)
 - [PipelinePipelineWatchEvent](docs/PipelinePipelineWatchEvent.md)
 - [PipelineStepWatchEvent](docs/PipelineStepWatchEvent.md)
 - [PodAffinity](docs/PodAffinity.md)
 - [PodAffinityTerm](docs/PodAffinityTerm.md)
 - [PodAntiAffinity](docs/PodAntiAffinity.md)
 - [PodDNSConfig](docs/PodDNSConfig.md)
 - [PodDNSConfigOption](docs/PodDNSConfigOption.md)
 - [PodSecurityContext](docs/PodSecurityContext.md)
 - [PortworxVolumeSource](docs/PortworxVolumeSource.md)
 - [PreferredSchedulingTerm](docs/PreferredSchedulingTerm.md)
 - [Probe](docs/Probe.md)
 - [ProjectedVolumeSource](docs/ProjectedVolumeSource.md)
 - [QuobyteVolumeSource](docs/QuobyteVolumeSource.md)
 - [RBDVolumeSource](docs/RBDVolumeSource.md)
 - [ResourceFieldSelector](docs/ResourceFieldSelector.md)
 - [ResourceRequirements](docs/ResourceRequirements.md)
 - [SELinuxOptions](docs/SELinuxOptions.md)
 - [ScaleIOVolumeSource](docs/ScaleIOVolumeSource.md)
 - [SeccompProfile](docs/SeccompProfile.md)
 - [SecretEnvSource](docs/SecretEnvSource.md)
 - [SecretKeySelector](docs/SecretKeySelector.md)
 - [SecretProjection](docs/SecretProjection.md)
 - [SecretVolumeSource](docs/SecretVolumeSource.md)
 - [SecurityContext](docs/SecurityContext.md)
 - [SensorCreateSensorRequest](docs/SensorCreateSensorRequest.md)
 - [SensorLogEntry](docs/SensorLogEntry.md)
 - [SensorSensorWatchEvent](docs/SensorSensorWatchEvent.md)
 - [SensorUpdateSensorRequest](docs/SensorUpdateSensorRequest.md)
 - [ServiceAccountTokenProjection](docs/ServiceAccountTokenProjection.md)
 - [ServicePort](docs/ServicePort.md)
 - [StatusCause](docs/StatusCause.md)
 - [StorageOSVolumeSource](docs/StorageOSVolumeSource.md)
 - [StreamResultOfEvent](docs/StreamResultOfEvent.md)
 - [StreamResultOfEventsourceEventSourceWatchEvent](docs/StreamResultOfEventsourceEventSourceWatchEvent.md)
 - [StreamResultOfEventsourceLogEntry](docs/StreamResultOfEventsourceLogEntry.md)
 - [StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry](docs/StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry.md)
 - [StreamResultOfIoArgoprojWorkflowV1alpha1WorkflowWatchEvent](docs/StreamResultOfIoArgoprojWorkflowV1alpha1WorkflowWatchEvent.md)
 - [StreamResultOfPipelineLogEntry](docs/StreamResultOfPipelineLogEntry.md)
 - [StreamResultOfPipelinePipelineWatchEvent](docs/StreamResultOfPipelinePipelineWatchEvent.md)
 - [StreamResultOfPipelineStepWatchEvent](docs/StreamResultOfPipelineStepWatchEvent.md)
 - [StreamResultOfSensorLogEntry](docs/StreamResultOfSensorLogEntry.md)
 - [StreamResultOfSensorSensorWatchEvent](docs/StreamResultOfSensorSensorWatchEvent.md)
 - [Sysctl](docs/Sysctl.md)
 - [TCPSocketAction](docs/TCPSocketAction.md)
 - [Toleration](docs/Toleration.md)
 - [TypedLocalObjectReference](docs/TypedLocalObjectReference.md)
 - [Volume](docs/Volume.md)
 - [VolumeDevice](docs/VolumeDevice.md)
 - [VolumeMount](docs/VolumeMount.md)
 - [VolumeProjection](docs/VolumeProjection.md)
 - [VsphereVirtualDiskVolumeSource](docs/VsphereVirtualDiskVolumeSource.md)
 - [WeightedPodAffinityTerm](docs/WeightedPodAffinityTerm.md)
 - [WindowsSecurityContextOptions](docs/WindowsSecurityContextOptions.md)


## Documentation For Authorization


## BearerToken

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in argo_workflows.apis and argo_workflows.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from argo_workflows.api.default_api import DefaultApi`
- `from argo_workflows.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import argo_workflows
from argo_workflows.apis import *
from argo_workflows.models import *
```

