
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/python/arcor2_kinect_azure:arcor2_kinect_azure_dist

from setuptools import setup

setup(**{
    'author': 'Robo@FIT',
    'author_email': 'imaterna@fit.vut.cz',
    'classifiers': [
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: GNU Lesser General Public License v3 (LGPLv3)',
        'Programming Language :: Python :: 3.10',
        'Natural Language :: English',
        'Topic :: Scientific/Engineering',
    ],
    'description': 'REST API for Kinect Azure.',
    'entry_points': {
        'console_scripts': [
            'arcor2_kinect_azure = arcor2_kinect_azure.scripts.kinect_azure:main',
        ],
    },
    'install_requires': (
        'Flask~=2.2.2',
        'Pillow~=9.2.0',
        'arcor2~=0.25.0',
        'numpy~=1.23.4',
        'pyk4a~=1.4.0',
    ),
    'license': 'LGPL',
    'long_description': """# Kinect Azure Service

## Usage Instructions

- By default, the service runs on port 5016.
  - This can be changed by setting `ARCOR2_KINECT_AZURE_URL`.
- Kinect SDK has to be installed beforehand (`sudo ./build-support/install_kinect_prerequisites.sh`).
- You may need to run following commands when using the real sensor to set permissions:

```bash
sudo wget https://raw.githubusercontent.com/microsoft/Azure-Kinect-Sensor-SDK/develop/scripts/99-k4a.rules -P /etc/udev/rules.d/
sudo udevadm control --reload-rules && udevadm trigger
```

## Environment variables

- `ARCOR2_KINECT_AZURE_URL=http://localhost:5016` - by default, the service listens on port 5016.
- `ARCOR2_KINECT_AZURE_MOCK=1` - the service will start in a mock (simulator) mode.
- `ARCOR2_REST_API_DEBUG=1` - turns on Flask debugging (logs each endpoint call).
# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),

## [0.5.0] - 2022-10-28

### Changed

- **BREAKING**: Implement new error handling flow. Error codes of **every** endpoint were replaced with error 
  types as described in swagger documentation.
- Changed service name.
- Switched to Python 3.10, updated dependencies.

## [0.4.0] - 2021-10-25

### Changed

- New environment variable `ARCOR2_KINECT_AZURE_MOCK`.

### Fixed 

- Depth file was not packaged (used in mock mode).

## [0.3.0] - 2021-05-21

### Changed

- Lazy import of `pyk4a` - mock can run without it.

## [0.2.0] - 2021-02-08

### Changed
- Mock now sends real images.
- Part of the code refactored into `arcor2/flask.py`.

## [0.1.0] - 2020-12-14

### Changed
- Initial release of the package.""",
    'long_description_content_type': 'text/markdown',
    'name': 'arcor2_kinect_azure',
    'namespace_packages': (
    ),
    'package_data': {
        'arcor2_kinect_azure': (
            'VERSION',
            'data/depth.png',
            'data/rgb.jpg',
            'py.typed',
        ),
    },
    'packages': (
        'arcor2_kinect_azure',
        'arcor2_kinect_azure.scripts',
    ),
    'python_requires': '==3.10.*',
    'version': '0.5.0',
})
