import apacepy.analysis.Trajectories as A


def plot(prev_multiplier=52, incd_multiplier=1, obs_incd_multiplier=1, filename='trajectories.png'):
    """
    :param prev_multiplier: (int) to multiply the simulation time to convert it to year, week, or day.
    :param incd_multiplier: (int) to multiply the simulation period to convert it to year, week, or day.
    :param filename: (string) filename to save the trajectories as
    :return:
    """

    sim_outcomes = A.SimOutcomeTrajectories(csv_directory='outputs/trajectories/')

    # defaults
    A.X_TICKS = [0, 5]  # x-axis ticks (min at 0 with interval of 5)
    A.X_LABEL = 'Weeks'  # x-axis label

    # plot information
    S = A.TrajPlotInfo(outcome_name='In: Susceptible',
                       title='Susceptible',
                       x_multiplier=prev_multiplier)
    I = A.TrajPlotInfo(outcome_name='In: Infectious',
                       title='Infectious',
                       x_multiplier=prev_multiplier)
    R = A.TrajPlotInfo(outcome_name='In: Recovered',
                       title='Recovered',
                       x_multiplier=prev_multiplier)
    Prev = A.TrajPlotInfo(outcome_name='Prevalence',
                          title='Prevalence (%)',
                          x_multiplier=prev_multiplier,
                          y_multiplier=100) # to convert to %
    Inc = A.TrajPlotInfo(outcome_name='To: Infectious',
                         title='Incidence',
                         x_multiplier=incd_multiplier)
    ObsInc = A.TrajPlotInfo(outcome_name='Obs: Incidence',
                            title='Observed Incidence',
                            x_multiplier=obs_incd_multiplier)

    sim_outcomes.plot_multi_panel(n_rows=2, n_cols=3,
                                  list_plot_info=[S, I, R, Prev, Inc, ObsInc],
                                  file_name='figures/'+filename)
