# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class UpdateWalletRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    UpdateWalletRequest - a model defined in OpenAPI
        image_url: Image url for this wallet. This image url is publicized            (self-attested) to other agents as part of forming a connection. [Optional].
        label: Label for this wallet. This label is publicized            (self-attested) to other agents as part of forming a connection. [Optional].
        wallet_dispatch_type: Webhook target dispatch type for this wallet.             default - Dispatch only to webhooks associated with this wallet.             base - Dispatch only to webhooks associated with the base wallet.             both - Dispatch to both webhook targets. [Optional].
        wallet_webhook_urls: List of Webhook URLs associated with this subwallet [Optional].
    """

    image_url: Optional[str] = None
    label: Optional[str] = None
    wallet_dispatch_type: Optional[Literal["default", "both", "base"]] = None
    wallet_webhook_urls: Optional[List[str]] = None

    def __init__(
        self,
        *,
        image_url: Optional[str] = None,
        label: Optional[str] = None,
        wallet_dispatch_type: Optional[Literal["default", "both", "base"]] = None,
        wallet_webhook_urls: Optional[List[str]] = None,
        **kwargs,
    ):
        super().__init__(
            image_url=image_url,
            label=label,
            wallet_dispatch_type=wallet_dispatch_type,
            wallet_webhook_urls=wallet_webhook_urls,
            **kwargs,
        )

    class Config:
        allow_population_by_field_name = True


UpdateWalletRequest.update_forward_refs()
