# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.model_schema import ModelSchema


class SchemaSendResult(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    SchemaSendResult - a model defined in OpenAPI
        schema_: Schema definition.
        schema_id: Schema identifier.
    """

    schema_: ModelSchema = Field(..., alias="schema")
    schema_id: str

    def __init__(
        self,
        *,
        schema_: ModelSchema = None,
        schema_id: str = None,
        **kwargs,
    ):
        super().__init__(
            schema_=schema_,
            schema_id=schema_id,
            **kwargs,
        )

    @validator("schema_id")
    def schema_id_pattern(cls, value):

        pattern = r"^[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of schema_id does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


SchemaSendResult.update_forward_refs()
