# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.indy_ge_proof_pred import IndyGEProofPred


class IndyGEProof(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    IndyGEProof - a model defined in OpenAPI
        alpha: The alpha of this IndyGEProof [Optional].
        mj: The mj of this IndyGEProof [Optional].
        predicate: The predicate of this IndyGEProof [Optional].
        r: The r of this IndyGEProof [Optional].
        t: The t of this IndyGEProof [Optional].
        u: The u of this IndyGEProof [Optional].
    """

    alpha: Optional[str] = None
    mj: Optional[str] = None
    predicate: Optional[IndyGEProofPred] = None
    r: Optional[Dict[str, str]] = None
    t: Optional[Dict[str, str]] = None
    u: Optional[Dict[str, str]] = None

    def __init__(
        self,
        *,
        alpha: Optional[str] = None,
        mj: Optional[str] = None,
        predicate: Optional[IndyGEProofPred] = None,
        r: Optional[Dict[str, str]] = None,
        t: Optional[Dict[str, str]] = None,
        u: Optional[Dict[str, str]] = None,
        **kwargs,
    ):
        super().__init__(
            alpha=alpha,
            mj=mj,
            predicate=predicate,
            r=r,
            t=t,
            u=u,
            **kwargs,
        )

    @validator("alpha")
    def alpha_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of alpha does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("mj")
    def mj_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(f"Value of mj does not match regex pattern ('{pattern}')")
        return value

    class Config:
        allow_population_by_field_name = True


IndyGEProof.update_forward_refs()
