# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.dif_field import DIFField
from aries_cloudcontroller.model.dif_holder import DIFHolder


class Constraints(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    Constraints - a model defined in OpenAPI
        fields: The fields of this Constraints [Optional].
        is_holder: The is_holder of this Constraints [Optional].
        limit_disclosure: LimitDisclosure [Optional].
        status_active: The status_active of this Constraints [Optional].
        status_revoked: The status_revoked of this Constraints [Optional].
        status_suspended: The status_suspended of this Constraints [Optional].
        subject_is_issuer: SubjectIsIssuer [Optional].
    """

    fields: Optional[List[DIFField]] = None
    is_holder: Optional[List[DIFHolder]] = None
    limit_disclosure: Optional[str] = None
    status_active: Optional[Literal["required", "allowed", "disallowed"]] = None
    status_revoked: Optional[Literal["required", "allowed", "disallowed"]] = None
    status_suspended: Optional[Literal["required", "allowed", "disallowed"]] = None
    subject_is_issuer: Optional[Literal["required", "preferred"]] = None

    def __init__(
        self,
        *,
        fields: Optional[List[DIFField]] = None,
        is_holder: Optional[List[DIFHolder]] = None,
        limit_disclosure: Optional[str] = None,
        status_active: Optional[Literal["required", "allowed", "disallowed"]] = None,
        status_revoked: Optional[Literal["required", "allowed", "disallowed"]] = None,
        status_suspended: Optional[Literal["required", "allowed", "disallowed"]] = None,
        subject_is_issuer: Optional[Literal["required", "preferred"]] = None,
        **kwargs,
    ):
        super().__init__(
            fields=fields,
            is_holder=is_holder,
            limit_disclosure=limit_disclosure,
            status_active=status_active,
            status_revoked=status_revoked,
            status_suspended=status_suspended,
            subject_is_issuer=subject_is_issuer,
            **kwargs,
        )

    class Config:
        allow_population_by_field_name = True


Constraints.update_forward_refs()
